/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.OverrideTaskStepProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RunRequest;
import java.io.IOException;

public final class TaskRunRequest
extends RunRequest {
    private String type = "TaskRunRequest";
    private String taskId;
    private OverrideTaskStepProperties overrideTaskStepProperties;
    private static final ClientLogger LOGGER = new ClientLogger(TaskRunRequest.class);

    @Override
    public String type() {
        return this.type;
    }

    public String taskId() {
        return this.taskId;
    }

    public TaskRunRequest withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public OverrideTaskStepProperties overrideTaskStepProperties() {
        return this.overrideTaskStepProperties;
    }

    public TaskRunRequest withOverrideTaskStepProperties(OverrideTaskStepProperties overrideTaskStepProperties) {
        this.overrideTaskStepProperties = overrideTaskStepProperties;
        return this;
    }

    @Override
    public TaskRunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    @Override
    public TaskRunRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    @Override
    public TaskRunRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.taskId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property taskId in model TaskRunRequest"));
        }
        if (this.overrideTaskStepProperties() != null) {
            this.overrideTaskStepProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled());
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName());
        jsonWriter.writeStringField("logTemplate", this.logTemplate());
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("overrideTaskStepProperties", this.overrideTaskStepProperties);
        return jsonWriter.writeEndObject();
    }

    public static TaskRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskRunRequest deserializedTaskRunRequest = new TaskRunRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedTaskRunRequest.withIsArchiveEnabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("agentPoolName".equals(fieldName)) {
                    deserializedTaskRunRequest.withAgentPoolName(reader.getString());
                    continue;
                }
                if ("logTemplate".equals(fieldName)) {
                    deserializedTaskRunRequest.withLogTemplate(reader.getString());
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    deserializedTaskRunRequest.taskId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTaskRunRequest.type = reader.getString();
                    continue;
                }
                if ("overrideTaskStepProperties".equals(fieldName)) {
                    deserializedTaskRunRequest.overrideTaskStepProperties = OverrideTaskStepProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskRunRequest;
        });
    }
}

