/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.BaseImageDependency;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.DockerTaskStep;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.EncodedTaskStep;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.FileTaskStep;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.StepType;
import java.io.IOException;
import java.util.List;

public class TaskStepProperties
implements JsonSerializable<TaskStepProperties> {
    private StepType type = StepType.fromString("TaskStepProperties");
    private List<BaseImageDependency> baseImageDependencies;
    private String contextPath;
    private String contextAccessToken;

    public StepType type() {
        return this.type;
    }

    public List<BaseImageDependency> baseImageDependencies() {
        return this.baseImageDependencies;
    }

    TaskStepProperties withBaseImageDependencies(List<BaseImageDependency> baseImageDependencies) {
        this.baseImageDependencies = baseImageDependencies;
        return this;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public TaskStepProperties withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String contextAccessToken() {
        return this.contextAccessToken;
    }

    public TaskStepProperties withContextAccessToken(String contextAccessToken) {
        this.contextAccessToken = contextAccessToken;
        return this;
    }

    public void validate() {
        if (this.baseImageDependencies() != null) {
            this.baseImageDependencies().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("contextPath", this.contextPath);
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken);
        return jsonWriter.writeEndObject();
    }

    public static TaskStepProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                TaskStepProperties taskStepProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("FileTask".equals(discriminatorValue)) {
                    taskStepProperties = FileTaskStep.fromJson(readerToUse.reset());
                    return taskStepProperties;
                }
                if ("EncodedTask".equals(discriminatorValue)) {
                    taskStepProperties = EncodedTaskStep.fromJson(readerToUse.reset());
                    return taskStepProperties;
                }
                if ("Docker".equals(discriminatorValue)) {
                    taskStepProperties = DockerTaskStep.fromJson(readerToUse.reset());
                    return taskStepProperties;
                }
                taskStepProperties = TaskStepProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return taskStepProperties;
            }
        });
    }

    static TaskStepProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskStepProperties deserializedTaskStepProperties = new TaskStepProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTaskStepProperties.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("baseImageDependencies".equals(fieldName)) {
                    List<BaseImageDependency> baseImageDependencies = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    deserializedTaskStepProperties.baseImageDependencies = baseImageDependencies;
                    continue;
                }
                if ("contextPath".equals(fieldName)) {
                    deserializedTaskStepProperties.contextPath = reader.getString();
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedTaskStepProperties.contextAccessToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskStepProperties;
        });
    }
}

