/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.WebhookPropertiesCreateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WebhookCreateParameters
implements JsonSerializable<WebhookCreateParameters> {
    private Map<String, String> tags;
    private String location;
    private WebhookPropertiesCreateParameters innerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(WebhookCreateParameters.class);

    public Map<String, String> tags() {
        return this.tags;
    }

    public WebhookCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public WebhookCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    private WebhookPropertiesCreateParameters innerProperties() {
        return this.innerProperties;
    }

    public String serviceUri() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceUri();
    }

    public WebhookCreateParameters withServiceUri(String serviceUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withServiceUri(serviceUri);
        return this;
    }

    public Map<String, String> customHeaders() {
        return this.innerProperties() == null ? null : this.innerProperties().customHeaders();
    }

    public WebhookCreateParameters withCustomHeaders(Map<String, String> customHeaders) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withCustomHeaders(customHeaders);
        return this;
    }

    public WebhookStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public WebhookCreateParameters withStatus(WebhookStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public WebhookCreateParameters withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    public List<WebhookAction> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public WebhookCreateParameters withActions(List<WebhookAction> actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property location in model WebhookCreateParameters"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebhookCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebhookCreateParameters deserializedWebhookCreateParameters = new WebhookCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedWebhookCreateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWebhookCreateParameters.tags = tags;
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebhookCreateParameters.innerProperties = WebhookPropertiesCreateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookCreateParameters;
        });
    }
}

