/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.PrivateEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.PrivateEndpointConnectionProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.PrivateLinkServiceConnectionState;
import java.io.IOException;

public final class PrivateEndpointConnectionProperties
implements JsonSerializable<PrivateEndpointConnectionProperties> {
    private PrivateEndpointConnectionProvisioningState provisioningState;
    private PrivateEndpoint privateEndpoint;
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionProperties.class);

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PrivateEndpoint privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateEndpointConnectionProperties withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property privateLinkServiceConnectionState in model PrivateEndpointConnectionProperties"));
        }
        this.privateLinkServiceConnectionState().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", this.privateLinkServiceConnectionState);
        jsonWriter.writeJsonField("privateEndpoint", this.privateEndpoint);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateEndpointConnectionProperties deserializedPrivateEndpointConnectionProperties = new PrivateEndpointConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateLinkServiceConnectionState = PrivateLinkServiceConnectionState.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.provisioningState = PrivateEndpointConnectionProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateEndpoint = PrivateEndpoint.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionProperties;
        });
    }
}

