/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MongoRoleDefinitionType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.Privilege;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.Role;
import java.io.IOException;
import java.util.List;

public final class MongoRoleDefinitionResource
implements JsonSerializable<MongoRoleDefinitionResource> {
    private String roleName;
    private MongoRoleDefinitionType type;
    private String databaseName;
    private List<Privilege> privileges;
    private List<Role> roles;

    public String roleName() {
        return this.roleName;
    }

    public MongoRoleDefinitionResource withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public MongoRoleDefinitionType type() {
        return this.type;
    }

    public MongoRoleDefinitionResource withType(MongoRoleDefinitionType type) {
        this.type = type;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public MongoRoleDefinitionResource withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public List<Privilege> privileges() {
        return this.privileges;
    }

    public MongoRoleDefinitionResource withPrivileges(List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public MongoRoleDefinitionResource withRoles(List<Role> roles) {
        this.roles = roles;
        return this;
    }

    public void validate() {
        if (this.privileges() != null) {
            this.privileges().forEach(e -> e.validate());
        }
        if (this.roles() != null) {
            this.roles().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleName", this.roleName);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeArrayField("privileges", this.privileges, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static MongoRoleDefinitionResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoRoleDefinitionResource deserializedMongoRoleDefinitionResource = new MongoRoleDefinitionResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleName".equals(fieldName)) {
                    deserializedMongoRoleDefinitionResource.roleName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoRoleDefinitionResource.type = MongoRoleDefinitionType.fromString(reader.getString());
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMongoRoleDefinitionResource.databaseName = reader.getString();
                    continue;
                }
                if ("privileges".equals(fieldName)) {
                    List<Privilege> privileges = reader.readArray(reader1 -> Privilege.fromJson(reader1));
                    deserializedMongoRoleDefinitionResource.privileges = privileges;
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List<Role> roles = reader.readArray(reader1 -> Role.fromJson(reader1));
                    deserializedMongoRoleDefinitionResource.roles = roles;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoRoleDefinitionResource;
        });
    }
}

