/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.CosmosManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.CosmosDBManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountGetResultsInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListConnectionStringsResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListKeysResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListReadOnlyKeysResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.PrivateEndpointConnectionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.PrivateEndpointConnectionsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.PrivateLinkResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.SqlDatabaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.Capability;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountCreateUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountListConnectionStringsResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountListKeysResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountListReadOnlyKeysResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountOfferType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountRegenerateKeyParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DefaultConsistencyLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.FailoverPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.KeyKind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.Location;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PrivateEndpointConnection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PrivateLinkResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PrivateLinkServiceConnectionStateProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.RegionForOnlineOffline;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.SqlDatabase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointServiceConnectionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class CosmosDBAccountImpl
extends GroupableResourceImpl<CosmosDBAccount, DatabaseAccountGetResultsInner, CosmosDBAccountImpl, CosmosManager>
implements CosmosDBAccount,
CosmosDBAccount.Definition,
CosmosDBAccount.Update {
    private List<FailoverPolicy> failoverPolicies = new ArrayList<FailoverPolicy>();
    private boolean hasFailoverPolicyChanges;
    private static final int MAX_DELAY_DUE_TO_MISSING_FAILOVERS = 600;
    private Map<String, VirtualNetworkRule> virtualNetworkRulesMap;
    private PrivateEndpointConnectionsImpl privateEndpointConnections = new PrivateEndpointConnectionsImpl(((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateEndpointConnections(), this);

    CosmosDBAccountImpl(String name, DatabaseAccountGetResultsInner innerObject, CosmosManager manager) {
        super(CosmosDBAccountImpl.fixDBName(name), innerObject, manager);
    }

    @Override
    public DatabaseAccountKind kind() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).kind();
    }

    @Override
    public String documentEndpoint() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).documentEndpoint();
    }

    @Override
    public DatabaseAccountOfferType databaseAccountOfferType() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).databaseAccountOfferType();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).publicNetworkAccess();
    }

    @Override
    public String ipRangeFilter() {
        if (CoreUtils.isNullOrEmpty(this.ipRules())) {
            return null;
        }
        return this.ipRules().stream().map(IpAddressOrRange::ipAddressOrRange).collect(Collectors.joining(","));
    }

    @Override
    public List<IpAddressOrRange> ipRules() {
        return Collections.unmodifiableList(((DatabaseAccountGetResultsInner)this.innerModel()).ipRules());
    }

    @Override
    public ConsistencyPolicy consistencyPolicy() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).consistencyPolicy();
    }

    @Override
    public DefaultConsistencyLevel defaultConsistencyLevel() {
        if (((DatabaseAccountGetResultsInner)this.innerModel()).consistencyPolicy() == null) {
            throw new RuntimeException("Consistency policy is missing!");
        }
        return ((DatabaseAccountGetResultsInner)this.innerModel()).consistencyPolicy().defaultConsistencyLevel();
    }

    @Override
    public List<Location> writableReplications() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).writeLocations();
    }

    @Override
    public List<Location> readableReplications() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).readLocations();
    }

    @Override
    public DatabaseAccountListKeysResult listKeys() {
        return this.listKeysAsync().block();
    }

    @Override
    public Mono<DatabaseAccountListKeysResult> listKeysAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listKeysAsync(this.resourceGroupName(), this.name()).map(DatabaseAccountListKeysResultImpl::new);
    }

    @Override
    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys() {
        return this.listReadOnlyKeysAsync().block();
    }

    @Override
    public Mono<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listReadOnlyKeysAsync(this.resourceGroupName(), this.name()).map(DatabaseAccountListReadOnlyKeysResultImpl::new);
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings() {
        return this.listConnectionStringsAsync().block();
    }

    @Override
    public Mono<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listConnectionStringsAsync(this.resourceGroupName(), this.name()).map(DatabaseAccountListConnectionStringsResultImpl::new);
    }

    @Override
    public List<SqlDatabase> listSqlDatabases() {
        return this.listSqlDatabasesAsync().collectList().block();
    }

    @Override
    public PagedFlux<SqlDatabase> listSqlDatabasesAsync() {
        return PagedConverter.mapPage(((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getSqlResources().listSqlDatabasesAsync(this.resourceGroupName(), this.name()), SqlDatabaseImpl::new);
    }

    @Override
    public List<PrivateLinkResource> listPrivateLinkResources() {
        return this.listPrivateLinkResourcesAsync().collectList().block();
    }

    @Override
    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        return PagedConverter.mapPage(((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateLinkResources().listByDatabaseAccountAsync(this.resourceGroupName(), this.name()), PrivateLinkResourceImpl::new);
    }

    @Override
    public PrivateLinkResource getPrivateLinkResource(String groupName) {
        return this.getPrivateLinkResourceAsync(groupName).block();
    }

    @Override
    public Mono<PrivateLinkResource> getPrivateLinkResourceAsync(String groupName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateLinkResources().getAsync(this.resourceGroupName(), this.name(), groupName).map(PrivateLinkResourceImpl::new);
    }

    @Override
    public Map<String, PrivateEndpointConnection> listPrivateEndpointConnection() {
        return this.listPrivateEndpointConnectionAsync().block();
    }

    @Override
    public Mono<Map<String, PrivateEndpointConnection>> listPrivateEndpointConnectionAsync() {
        return this.privateEndpointConnections.asMapAsync();
    }

    @Override
    public PrivateEndpointConnection getPrivateEndpointConnection(String name) {
        return this.getPrivateEndpointConnectionAsync(name).block();
    }

    @Override
    public Mono<PrivateEndpointConnection> getPrivateEndpointConnectionAsync(String name) {
        return this.privateEndpointConnections.getImplAsync(name).map(privateEndpointConnection -> privateEndpointConnection);
    }

    @Override
    public boolean multipleWriteLocationsEnabled() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).enableMultipleWriteLocations();
    }

    @Override
    public boolean cassandraConnectorEnabled() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).enableCassandraConnector();
    }

    @Override
    public ConnectorOffer cassandraConnectorOffer() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).connectorOffer();
    }

    @Override
    public boolean keyBasedMetadataWriteAccessDisabled() {
        return ((DatabaseAccountGetResultsInner)this.innerModel()).disableKeyBasedMetadataWriteAccess();
    }

    @Override
    public List<Capability> capabilities() {
        List<Capability> capabilities = ((DatabaseAccountGetResultsInner)this.innerModel()).capabilities();
        if (capabilities == null) {
            capabilities = new ArrayList<Capability>();
        }
        return Collections.unmodifiableList(capabilities);
    }

    @Override
    public List<VirtualNetworkRule> virtualNetworkRules() {
        ArrayList result = this.innerModel() != null && ((DatabaseAccountGetResultsInner)this.innerModel()).virtualNetworkRules() != null ? ((DatabaseAccountGetResultsInner)this.innerModel()).virtualNetworkRules() : new ArrayList();
        return Collections.unmodifiableList(result);
    }

    @Override
    public void offlineRegion(Region region) {
        ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().offlineRegion(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public Mono<Void> offlineRegionAsync(Region region) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().offlineRegionAsync(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public void onlineRegion(Region region) {
        ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().onlineRegion(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public Mono<Void> onlineRegionAsync(Region region) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().onlineRegionAsync(this.resourceGroupName(), this.name(), new RegionForOnlineOffline().withRegion(region.label()));
    }

    @Override
    public void regenerateKey(KeyKind keyKind) {
        ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().regenerateKey(this.resourceGroupName(), this.name(), new DatabaseAccountRegenerateKeyParameters().withKeyKind(keyKind));
    }

    @Override
    public Mono<Void> regenerateKeyAsync(KeyKind keyKind) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().regenerateKeyAsync(this.resourceGroupName(), this.name(), new DatabaseAccountRegenerateKeyParameters().withKeyKind(keyKind));
    }

    @Override
    public CosmosDBAccountImpl withKind(DatabaseAccountKind kind) {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withKind(kind);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withKind(DatabaseAccountKind kind, Capability ... capabilities) {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withKind(kind);
        ((DatabaseAccountGetResultsInner)this.innerModel()).withCapabilities(Arrays.asList(capabilities));
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelSql() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelMongoDB() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withKind(DatabaseAccountKind.MONGO_DB);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelCassandra() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableCassandra"));
        ((DatabaseAccountGetResultsInner)this.innerModel()).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Cassandra");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelAzureTable() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableTable"));
        ((DatabaseAccountGetResultsInner)this.innerModel()).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Table");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelGremlin() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableGremlin"));
        ((DatabaseAccountGetResultsInner)this.innerModel()).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Graph");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withIpRangeFilter(String ipRangeFilter) {
        ArrayList<IpAddressOrRange> rules = new ArrayList<IpAddressOrRange>();
        if (!CoreUtils.isNullOrEmpty(ipRangeFilter)) {
            for (String ip : ipRangeFilter.split(",")) {
                rules.add(new IpAddressOrRange().withIpAddressOrRange(ip));
            }
        }
        ((DatabaseAccountGetResultsInner)this.innerModel()).withIpRules(rules);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withIpRules(List<IpAddressOrRange> ipRules) {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withIpRules(ipRules);
        return this;
    }

    @Override
    protected Mono<DatabaseAccountGetResultsInner> getInnerAsync() {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public CosmosDBAccountImpl withWriteReplication(Region region) {
        FailoverPolicy failoverPolicyInner = new FailoverPolicy();
        failoverPolicyInner.withLocationName(region.name());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        FailoverPolicy failoverPolicyInner = new FailoverPolicy();
        failoverPolicyInner.withLocationName(region.name());
        failoverPolicyInner.withFailoverPriority(this.failoverPolicies.size());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        for (int i = 1; i < this.failoverPolicies.size(); ++i) {
            String locName;
            if (this.failoverPolicies.get(i).locationName() == null || !(locName = CosmosDBAccountImpl.formatLocationName(this.failoverPolicies.get(i).locationName())).equals(region.name())) continue;
            this.failoverPolicies.remove(i);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withEventualConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.EVENTUAL, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withSessionConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.SESSION, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withBoundedStalenessConsistency(long maxStalenessPrefix, int maxIntervalInSeconds) {
        this.setConsistencyPolicy(DefaultConsistencyLevel.BOUNDED_STALENESS, maxStalenessPrefix, maxIntervalInSeconds);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withStrongConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.STRONG, 0L, 0);
        return this;
    }

    public PrivateEndpointConnectionImpl defineNewPrivateEndpointConnection(String name) {
        return this.privateEndpointConnections.define(name);
    }

    @Override
    public PrivateEndpointConnectionImpl updatePrivateEndpointConnection(String name) {
        return this.privateEndpointConnections.update(name);
    }

    @Override
    public CosmosDBAccountImpl withoutPrivateEndpointConnection(String name) {
        this.privateEndpointConnections.remove(name);
        return this;
    }

    CosmosDBAccountImpl withPrivateEndpointConnection(PrivateEndpointConnectionImpl privateEndpointConnection) {
        this.privateEndpointConnections.addPrivateEndpointConnection(privateEndpointConnection);
        return this;
    }

    @Override
    public Mono<CosmosDBAccount> createResourceAsync() {
        return this.doDatabaseUpdateCreate();
    }

    private DatabaseAccountCreateUpdateParameters createUpdateParametersInner(DatabaseAccountGetResultsInner inner) {
        this.ensureFailoverIsInitialized();
        DatabaseAccountCreateUpdateParameters createUpdateParametersInner = new DatabaseAccountCreateUpdateParameters();
        createUpdateParametersInner.withLocation(this.regionName().toLowerCase(Locale.ROOT));
        createUpdateParametersInner.withConsistencyPolicy(inner.consistencyPolicy());
        createUpdateParametersInner.withIpRules(inner.ipRules());
        createUpdateParametersInner.withKind(inner.kind());
        createUpdateParametersInner.withCapabilities(inner.capabilities());
        createUpdateParametersInner.withTags((Map)inner.tags());
        createUpdateParametersInner.withEnableMultipleWriteLocations(inner.enableMultipleWriteLocations());
        this.addLocationsForParameters(new CreateUpdateLocationParameters(createUpdateParametersInner), this.failoverPolicies);
        createUpdateParametersInner.withIsVirtualNetworkFilterEnabled(inner.isVirtualNetworkFilterEnabled());
        createUpdateParametersInner.withEnableCassandraConnector(inner.enableCassandraConnector());
        createUpdateParametersInner.withConnectorOffer(inner.connectorOffer());
        createUpdateParametersInner.withEnableAutomaticFailover(inner.enableAutomaticFailover());
        createUpdateParametersInner.withDisableKeyBasedMetadataWriteAccess(inner.disableKeyBasedMetadataWriteAccess());
        if (this.virtualNetworkRulesMap != null) {
            createUpdateParametersInner.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>(this.virtualNetworkRulesMap.values()));
            this.virtualNetworkRulesMap = null;
        }
        createUpdateParametersInner.withPublicNetworkAccess(inner.publicNetworkAccess());
        return createUpdateParametersInner;
    }

    private DatabaseAccountUpdateParameters updateParametersInner(DatabaseAccountGetResultsInner inner) {
        this.ensureFailoverIsInitialized();
        DatabaseAccountUpdateParameters updateParameters = new DatabaseAccountUpdateParameters();
        updateParameters.withTags(inner.tags());
        updateParameters.withLocation(this.regionName().toLowerCase(Locale.ROOT));
        updateParameters.withConsistencyPolicy(inner.consistencyPolicy());
        updateParameters.withIpRules(inner.ipRules());
        updateParameters.withIsVirtualNetworkFilterEnabled(inner.isVirtualNetworkFilterEnabled());
        updateParameters.withEnableAutomaticFailover(inner.enableAutomaticFailover());
        updateParameters.withCapabilities(inner.capabilities());
        updateParameters.withEnableMultipleWriteLocations(inner.enableMultipleWriteLocations());
        updateParameters.withEnableCassandraConnector(inner.enableCassandraConnector());
        updateParameters.withConnectorOffer(inner.connectorOffer());
        updateParameters.withDisableKeyBasedMetadataWriteAccess(inner.disableKeyBasedMetadataWriteAccess());
        if (this.virtualNetworkRulesMap != null) {
            updateParameters.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>(this.virtualNetworkRulesMap.values()));
            this.virtualNetworkRulesMap = null;
        }
        this.addLocationsForParameters(new UpdateLocationParameters(updateParameters), this.failoverPolicies);
        updateParameters.withPublicNetworkAccess(inner.publicNetworkAccess());
        return updateParameters;
    }

    private static String fixDBName(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    private void setConsistencyPolicy(DefaultConsistencyLevel level, long maxStalenessPrefix, int maxIntervalInSeconds) {
        ConsistencyPolicy policy = new ConsistencyPolicy();
        policy.withDefaultConsistencyLevel(level);
        if (level == DefaultConsistencyLevel.BOUNDED_STALENESS) {
            policy.withMaxStalenessPrefix(maxStalenessPrefix);
            policy.withMaxIntervalInSeconds(maxIntervalInSeconds);
        }
        ((DatabaseAccountGetResultsInner)this.innerModel()).withConsistencyPolicy(policy);
    }

    private void addLocationsForParameters(HasLocations locationParameters, List<FailoverPolicy> failoverPolicies) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (failoverPolicies.size() > 0) {
            for (int i = 0; i < failoverPolicies.size(); ++i) {
                FailoverPolicy policyInner = failoverPolicies.get(i);
                Location location = new Location();
                location.withFailoverPriority(i);
                location.withLocationName(policyInner.locationName());
                locations.add(location);
            }
        } else {
            Location location = new Location();
            location.withFailoverPriority(0);
            location.withLocationName(locationParameters.location());
            locations.add(location);
        }
        locationParameters.withLocations(locations);
    }

    private static String formatLocationName(String locationName) {
        return locationName.replace(" ", "").toLowerCase(Locale.ROOT);
    }

    private Mono<CosmosDBAccount> doDatabaseUpdateCreate() {
        CosmosDBAccountImpl self = this;
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(0);
        Mono<DatabaseAccountGetResultsInner> request = null;
        HasLocations locationParameters = null;
        if (this.isInCreateMode()) {
            DatabaseAccountCreateUpdateParameters createUpdateParametersInner = this.createUpdateParametersInner((DatabaseAccountGetResultsInner)this.innerModel());
            request = ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().createOrUpdateAsync(this.resourceGroupName(), this.name(), createUpdateParametersInner);
            locationParameters = new CreateUpdateLocationParameters(createUpdateParametersInner);
        } else {
            DatabaseAccountUpdateParameters updateParametersInner = this.updateParametersInner((DatabaseAccountGetResultsInner)this.innerModel());
            request = ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().updateAsync(this.resourceGroupName(), this.name(), updateParametersInner);
            locationParameters = new UpdateLocationParameters(updateParametersInner);
        }
        Set locations = locationParameters.locations().stream().map(location -> CosmosDBAccountImpl.formatLocationName(location.locationName())).collect(Collectors.toSet());
        return request.flatMap(databaseAccountInner -> {
            self.failoverPolicies.clear();
            self.hasFailoverPolicyChanges = false;
            return ((CosmosManager)this.manager()).databaseAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name()).flatMap(databaseAccount -> {
                if (600 > (Integer)data.get(0) && (databaseAccount.id() == null || databaseAccount.id().length() == 0 || locations.size() != ((DatabaseAccountGetResultsInner)databaseAccount.innerModel()).failoverPolicies().size())) {
                    return Mono.empty();
                }
                if (this.isAFinalProvisioningState(((DatabaseAccountGetResultsInner)databaseAccount.innerModel()).provisioningState())) {
                    for (Location location : databaseAccount.readableReplications()) {
                        if (!this.isAFinalProvisioningState(location.provisioningState())) {
                            return Mono.empty();
                        }
                        if (locations.contains(CosmosDBAccountImpl.formatLocationName(location.locationName()))) continue;
                        return Mono.empty();
                    }
                } else {
                    return Mono.empty();
                }
                self.setInner((DatabaseAccountGetResultsInner)databaseAccount.innerModel());
                return Mono.just(databaseAccount);
            }).repeatWhenEmpty(longFlux -> longFlux.flatMap(index -> {
                data.set(0, (Integer)data.get(0) + 30);
                return Mono.delay(ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDefaultPollInterval()));
            }));
        });
    }

    private void ensureFailoverIsInitialized() {
        if (this.isInCreateMode()) {
            return;
        }
        if (!this.hasFailoverPolicyChanges) {
            this.failoverPolicies.clear();
            FailoverPolicy[] policyInners = new FailoverPolicy[((DatabaseAccountGetResultsInner)this.innerModel()).failoverPolicies().size()];
            ((DatabaseAccountGetResultsInner)this.innerModel()).failoverPolicies().toArray(policyInners);
            Arrays.sort(policyInners, Comparator.comparing(FailoverPolicy::failoverPriority));
            for (int i = 0; i < policyInners.length; ++i) {
                this.failoverPolicies.add(policyInners[i]);
            }
            this.hasFailoverPolicyChanges = true;
        }
    }

    private boolean isAFinalProvisioningState(String state) {
        switch (state.toLowerCase(Locale.ROOT)) {
            case "succeeded": 
            case "canceled": 
            case "failed": {
                return true;
            }
        }
        return false;
    }

    private Map<String, VirtualNetworkRule> ensureVirtualNetworkRules() {
        if (this.virtualNetworkRulesMap == null) {
            this.virtualNetworkRulesMap = new HashMap<String, VirtualNetworkRule>();
            if (this.innerModel() != null && ((DatabaseAccountGetResultsInner)this.innerModel()).virtualNetworkRules() != null) {
                for (VirtualNetworkRule virtualNetworkRule : ((DatabaseAccountGetResultsInner)this.innerModel()).virtualNetworkRules()) {
                    this.virtualNetworkRulesMap.put(virtualNetworkRule.id(), virtualNetworkRule);
                }
            }
        }
        return this.virtualNetworkRulesMap;
    }

    @Override
    public CosmosDBAccountImpl withVirtualNetwork(String virtualNetworkId, String subnetName) {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withIsVirtualNetworkFilterEnabled(true);
        String vnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.ensureVirtualNetworkRules().put(vnetId, new VirtualNetworkRule().withId(vnetId));
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutVirtualNetwork(String virtualNetworkId, String subnetName) {
        Map<String, VirtualNetworkRule> vnetRules = this.ensureVirtualNetworkRules();
        vnetRules.remove(virtualNetworkId + "/subnets/" + subnetName);
        if (vnetRules.size() == 0) {
            ((DatabaseAccountGetResultsInner)this.innerModel()).withIsVirtualNetworkFilterEnabled(false);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        Map<String, VirtualNetworkRule> vnetRules = this.ensureVirtualNetworkRules();
        if (virtualNetworkRules == null || virtualNetworkRules.isEmpty()) {
            vnetRules.clear();
            ((DatabaseAccountGetResultsInner)this.innerModel()).withIsVirtualNetworkFilterEnabled(false);
            return this;
        }
        ((DatabaseAccountGetResultsInner)this.innerModel()).withIsVirtualNetworkFilterEnabled(true);
        for (VirtualNetworkRule vnetRule : virtualNetworkRules) {
            this.virtualNetworkRulesMap.put(vnetRule.id(), vnetRule);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withMultipleWriteLocationsEnabled(boolean enabled) {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withEnableMultipleWriteLocations(enabled);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withCassandraConnector(ConnectorOffer connectorOffer) {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withEnableCassandraConnector(true);
        ((DatabaseAccountGetResultsInner)this.innerModel()).withConnectorOffer(connectorOffer);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutCassandraConnector() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withEnableCassandraConnector(false);
        ((DatabaseAccountGetResultsInner)this.innerModel()).withConnectorOffer(null);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDisableKeyBaseMetadataWriteAccess(boolean disabled) {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withDisableKeyBasedMetadataWriteAccess(disabled);
        return this;
    }

    @Override
    public void approvePrivateEndpointConnection(String privateEndpointConnectionName) {
        this.approvePrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> approvePrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateEndpointConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionStateProperty().withStatus(PrivateEndpointServiceConnectionStatus.APPROVED.toString()))).then();
    }

    @Override
    public void rejectPrivateEndpointConnection(String privateEndpointConnectionName) {
        this.rejectPrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> rejectPrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getPrivateEndpointConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionStateProperty().withStatus(PrivateEndpointServiceConnectionStatus.REJECTED.toString()))).then();
    }

    @Override
    public CosmosDBAccountImpl enablePublicNetworkAccess() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        return this;
    }

    @Override
    public CosmosDBAccountImpl disablePublicNetworkAccess() {
        ((DatabaseAccountGetResultsInner)this.innerModel()).withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        return this;
    }

    static class CreateUpdateLocationParameters
    implements HasLocations {
        private DatabaseAccountCreateUpdateParameters parameters;

        CreateUpdateLocationParameters(DatabaseAccountCreateUpdateParameters parametersObject) {
            this.parameters = parametersObject;
        }

        @Override
        public String location() {
            return this.parameters.location();
        }

        @Override
        public List<Location> locations() {
            return this.parameters.locations();
        }

        @Override
        public void withLocations(List<Location> locations) {
            this.parameters.withLocations(locations);
        }
    }

    static interface HasLocations {
        public String location();

        public List<Location> locations();

        public void withLocations(List<Location> var1);
    }

    static class UpdateLocationParameters
    implements HasLocations {
        private DatabaseAccountUpdateParameters parameters;

        UpdateLocationParameters(DatabaseAccountUpdateParameters parametersObject) {
            this.parameters = parametersObject;
        }

        @Override
        public String location() {
            return this.parameters.location();
        }

        @Override
        public List<Location> locations() {
            return this.parameters.locations();
        }

        @Override
        public void withLocations(List<Location> locations) {
            this.parameters.withLocations(locations);
        }
    }
}

