/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.CosmosManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.CosmosDBManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.DatabaseAccountsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountGetResultsInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountListConnectionStringsResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountListKeysResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountListReadOnlyKeysResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.CosmosDBAccountImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListConnectionStringsResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListKeysResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListReadOnlyKeysResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CosmosDBAccounts;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountListConnectionStringsResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountListKeysResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountListReadOnlyKeysResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DatabaseAccountRegenerateKeyParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.FailoverPolicies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.FailoverPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.KeyKind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.Location;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.List;

public class CosmosDBAccountsImpl
extends GroupableResourcesImpl<CosmosDBAccount, CosmosDBAccountImpl, DatabaseAccountGetResultsInner, DatabaseAccountsClient, CosmosManager>
implements CosmosDBAccounts {
    public CosmosDBAccountsImpl(CosmosManager manager) {
        super(((CosmosDBManagementClient)manager.serviceClient()).getDatabaseAccounts(), manager);
    }

    @Override
    public PagedIterable<CosmosDBAccount> list() {
        return new PagedIterable<CosmosDBAccount>(this.listAsync());
    }

    @Override
    public PagedFlux<CosmosDBAccount> listAsync() {
        return PagedConverter.mapPage(((DatabaseAccountsClient)this.inner()).listAsync(), inner -> new CosmosDBAccountImpl(inner.name(), (DatabaseAccountGetResultsInner)inner, (CosmosManager)this.manager()));
    }

    @Override
    public PagedFlux<CosmosDBAccount> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<CosmosDBAccount>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((DatabaseAccountsClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<CosmosDBAccount> listByResourceGroup(String groupName) {
        return new PagedIterable<CosmosDBAccount>(this.listByResourceGroupAsync(groupName));
    }

    @Override
    protected Mono<DatabaseAccountGetResultsInner> getInnerAsync(String resourceGroupName, String name) {
        return ((DatabaseAccountsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    public CosmosDBAccountImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String groupName, String name) {
        return ((DatabaseAccountsClient)this.inner()).deleteAsync(groupName, name);
    }

    @Override
    protected CosmosDBAccountImpl wrapModel(String name) {
        return new CosmosDBAccountImpl(name, new DatabaseAccountGetResultsInner(), (CosmosManager)this.manager());
    }

    @Override
    protected CosmosDBAccountImpl wrapModel(DatabaseAccountGetResultsInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new CosmosDBAccountImpl(containerServiceInner.name(), containerServiceInner, (CosmosManager)this.manager());
    }

    @Override
    public void failoverPriorityChange(String groupName, String accountName, List<Location> failoverLocations) {
        this.failoverPriorityChangeAsync(groupName, accountName, failoverLocations).block();
    }

    @Override
    public Mono<Void> failoverPriorityChangeAsync(String groupName, String accountName, List<Location> failoverLocations) {
        ArrayList<FailoverPolicy> policyInners = new ArrayList<FailoverPolicy>();
        for (int i = 0; i < failoverLocations.size(); ++i) {
            Location location = failoverLocations.get(i);
            FailoverPolicy policyInner = new FailoverPolicy();
            policyInner.withLocationName(location.locationName());
            policyInner.withFailoverPriority(i);
            policyInners.add(policyInner);
        }
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().failoverPriorityChangeAsync(groupName, accountName, new FailoverPolicies().withFailoverPolicies(policyInners));
    }

    @Override
    public DatabaseAccountListKeysResult listKeys(String groupName, String accountName) {
        return this.listKeysAsync(groupName, accountName).block();
    }

    @Override
    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys(String groupName, String accountName) {
        return this.listReadOnlyKeysAsync(groupName, accountName).block();
    }

    @Override
    public Mono<DatabaseAccountListKeysResult> listKeysAsync(String groupName, String accountName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listKeysAsync(groupName, accountName).map(databaseAccountListKeysResultInner -> new DatabaseAccountListKeysResultImpl((DatabaseAccountListKeysResultInner)databaseAccountListKeysResultInner));
    }

    @Override
    public Mono<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync(String groupName, String accountName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listReadOnlyKeysAsync(groupName, accountName).map(databaseAccountListReadOnlyKeysResultInner -> new DatabaseAccountListReadOnlyKeysResultImpl((DatabaseAccountListReadOnlyKeysResultInner)databaseAccountListReadOnlyKeysResultInner));
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings(String groupName, String accountName) {
        return this.listConnectionStringsAsync(groupName, accountName).block();
    }

    @Override
    public Mono<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync(String groupName, String accountName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listConnectionStringsAsync(groupName, accountName).map(databaseAccountListConnectionStringsResultInner -> new DatabaseAccountListConnectionStringsResultImpl((DatabaseAccountListConnectionStringsResultInner)databaseAccountListConnectionStringsResultInner));
    }

    @Override
    public void regenerateKey(String groupName, String accountName, KeyKind keyKind) {
        this.regenerateKeyAsync(groupName, accountName, keyKind).block();
    }

    @Override
    public Mono<Void> regenerateKeyAsync(String groupName, String accountName, KeyKind keyKind) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().regenerateKeyAsync(groupName, accountName, new DatabaseAccountRegenerateKeyParameters().withKeyKind(keyKind));
    }
}

