/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.BackupPolicyMigrationState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.BackupPolicyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ContinuousModeBackupPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PeriodicModeBackupPolicy;
import java.io.IOException;

public class BackupPolicy
implements JsonSerializable<BackupPolicy> {
    private BackupPolicyType type = BackupPolicyType.fromString("BackupPolicy");
    private BackupPolicyMigrationState migrationState;

    public BackupPolicyType type() {
        return this.type;
    }

    public BackupPolicyMigrationState migrationState() {
        return this.migrationState;
    }

    public BackupPolicy withMigrationState(BackupPolicyMigrationState migrationState) {
        this.migrationState = migrationState;
        return this;
    }

    public void validate() {
        if (this.migrationState() != null) {
            this.migrationState().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("migrationState", this.migrationState);
        return jsonWriter.writeEndObject();
    }

    public static BackupPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BackupPolicy backupPolicy;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Periodic".equals(discriminatorValue)) {
                    backupPolicy = PeriodicModeBackupPolicy.fromJson(readerToUse.reset());
                    return backupPolicy;
                }
                if ("Continuous".equals(discriminatorValue)) {
                    backupPolicy = ContinuousModeBackupPolicy.fromJson(readerToUse.reset());
                    return backupPolicy;
                }
                backupPolicy = BackupPolicy.fromJsonKnownDiscriminator(readerToUse.reset());
                return backupPolicy;
            }
        });
    }

    static BackupPolicy fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupPolicy deserializedBackupPolicy = new BackupPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedBackupPolicy.type = BackupPolicyType.fromString(reader.getString());
                    continue;
                }
                if ("migrationState".equals(fieldName)) {
                    deserializedBackupPolicy.migrationState = BackupPolicyMigrationState.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupPolicy;
        });
    }
}

