/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CassandraSchema;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CassandraTableResource;
import java.io.IOException;

public final class CassandraTableGetPropertiesResource
extends CassandraTableResource {
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraTableGetPropertiesResource.class);

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public CassandraTableGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public CassandraTableGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    @Override
    public CassandraTableGetPropertiesResource withSchema(CassandraSchema schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public CassandraTableGetPropertiesResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model CassandraTableGetPropertiesResource"));
        }
        if (this.schema() != null) {
            this.schema().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeNumberField("defaultTtl", this.defaultTtl());
        jsonWriter.writeJsonField("schema", this.schema());
        jsonWriter.writeNumberField("analyticalStorageTtl", this.analyticalStorageTtl());
        return jsonWriter.writeEndObject();
    }

    public static CassandraTableGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraTableGetPropertiesResource deserializedCassandraTableGetPropertiesResource = new CassandraTableGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withDefaultTtl(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withSchema(CassandraSchema.fromJson(reader));
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withAnalyticalStorageTtl(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraTableGetPropertiesResource;
        });
    }
}

