/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.AuthenticationMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.AzureConnectionType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CassandraError;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.Certificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ManagedCassandraProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.SeedNode;
import java.io.IOException;
import java.util.List;

public final class ClusterResourceProperties
implements JsonSerializable<ClusterResourceProperties> {
    private ManagedCassandraProvisioningState provisioningState;
    private String restoreFromBackupId;
    private String delegatedManagementSubnetId;
    private String cassandraVersion;
    private String clusterNameOverride;
    private AuthenticationMethod authenticationMethod;
    private String initialCassandraAdminPassword;
    private SeedNode prometheusEndpoint;
    private Boolean repairEnabled;
    private List<Certificate> clientCertificates;
    private List<Certificate> externalGossipCertificates;
    private List<Certificate> gossipCertificates;
    private List<SeedNode> externalSeedNodes;
    private List<SeedNode> seedNodes;
    private Integer hoursBetweenBackups;
    private Boolean deallocated;
    private Boolean cassandraAuditLoggingEnabled;
    private CassandraError provisionError;
    private AzureConnectionType azureConnectionMethod;
    private String privateLinkResourceId;

    public ManagedCassandraProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ClusterResourceProperties withProvisioningState(ManagedCassandraProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String restoreFromBackupId() {
        return this.restoreFromBackupId;
    }

    public ClusterResourceProperties withRestoreFromBackupId(String restoreFromBackupId) {
        this.restoreFromBackupId = restoreFromBackupId;
        return this;
    }

    public String delegatedManagementSubnetId() {
        return this.delegatedManagementSubnetId;
    }

    public ClusterResourceProperties withDelegatedManagementSubnetId(String delegatedManagementSubnetId) {
        this.delegatedManagementSubnetId = delegatedManagementSubnetId;
        return this;
    }

    public String cassandraVersion() {
        return this.cassandraVersion;
    }

    public ClusterResourceProperties withCassandraVersion(String cassandraVersion) {
        this.cassandraVersion = cassandraVersion;
        return this;
    }

    public String clusterNameOverride() {
        return this.clusterNameOverride;
    }

    public ClusterResourceProperties withClusterNameOverride(String clusterNameOverride) {
        this.clusterNameOverride = clusterNameOverride;
        return this;
    }

    public AuthenticationMethod authenticationMethod() {
        return this.authenticationMethod;
    }

    public ClusterResourceProperties withAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    public String initialCassandraAdminPassword() {
        return this.initialCassandraAdminPassword;
    }

    public ClusterResourceProperties withInitialCassandraAdminPassword(String initialCassandraAdminPassword) {
        this.initialCassandraAdminPassword = initialCassandraAdminPassword;
        return this;
    }

    public SeedNode prometheusEndpoint() {
        return this.prometheusEndpoint;
    }

    public ClusterResourceProperties withPrometheusEndpoint(SeedNode prometheusEndpoint) {
        this.prometheusEndpoint = prometheusEndpoint;
        return this;
    }

    public Boolean repairEnabled() {
        return this.repairEnabled;
    }

    public ClusterResourceProperties withRepairEnabled(Boolean repairEnabled) {
        this.repairEnabled = repairEnabled;
        return this;
    }

    public List<Certificate> clientCertificates() {
        return this.clientCertificates;
    }

    public ClusterResourceProperties withClientCertificates(List<Certificate> clientCertificates) {
        this.clientCertificates = clientCertificates;
        return this;
    }

    public List<Certificate> externalGossipCertificates() {
        return this.externalGossipCertificates;
    }

    public ClusterResourceProperties withExternalGossipCertificates(List<Certificate> externalGossipCertificates) {
        this.externalGossipCertificates = externalGossipCertificates;
        return this;
    }

    public List<Certificate> gossipCertificates() {
        return this.gossipCertificates;
    }

    public List<SeedNode> externalSeedNodes() {
        return this.externalSeedNodes;
    }

    public ClusterResourceProperties withExternalSeedNodes(List<SeedNode> externalSeedNodes) {
        this.externalSeedNodes = externalSeedNodes;
        return this;
    }

    public List<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public Integer hoursBetweenBackups() {
        return this.hoursBetweenBackups;
    }

    public ClusterResourceProperties withHoursBetweenBackups(Integer hoursBetweenBackups) {
        this.hoursBetweenBackups = hoursBetweenBackups;
        return this;
    }

    public Boolean deallocated() {
        return this.deallocated;
    }

    public ClusterResourceProperties withDeallocated(Boolean deallocated) {
        this.deallocated = deallocated;
        return this;
    }

    public Boolean cassandraAuditLoggingEnabled() {
        return this.cassandraAuditLoggingEnabled;
    }

    public ClusterResourceProperties withCassandraAuditLoggingEnabled(Boolean cassandraAuditLoggingEnabled) {
        this.cassandraAuditLoggingEnabled = cassandraAuditLoggingEnabled;
        return this;
    }

    public CassandraError provisionError() {
        return this.provisionError;
    }

    public ClusterResourceProperties withProvisionError(CassandraError provisionError) {
        this.provisionError = provisionError;
        return this;
    }

    public AzureConnectionType azureConnectionMethod() {
        return this.azureConnectionMethod;
    }

    public ClusterResourceProperties withAzureConnectionMethod(AzureConnectionType azureConnectionMethod) {
        this.azureConnectionMethod = azureConnectionMethod;
        return this;
    }

    public String privateLinkResourceId() {
        return this.privateLinkResourceId;
    }

    public void validate() {
        if (this.prometheusEndpoint() != null) {
            this.prometheusEndpoint().validate();
        }
        if (this.clientCertificates() != null) {
            this.clientCertificates().forEach(e -> e.validate());
        }
        if (this.externalGossipCertificates() != null) {
            this.externalGossipCertificates().forEach(e -> e.validate());
        }
        if (this.gossipCertificates() != null) {
            this.gossipCertificates().forEach(e -> e.validate());
        }
        if (this.externalSeedNodes() != null) {
            this.externalSeedNodes().forEach(e -> e.validate());
        }
        if (this.seedNodes() != null) {
            this.seedNodes().forEach(e -> e.validate());
        }
        if (this.provisionError() != null) {
            this.provisionError().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("restoreFromBackupId", this.restoreFromBackupId);
        jsonWriter.writeStringField("delegatedManagementSubnetId", this.delegatedManagementSubnetId);
        jsonWriter.writeStringField("cassandraVersion", this.cassandraVersion);
        jsonWriter.writeStringField("clusterNameOverride", this.clusterNameOverride);
        jsonWriter.writeStringField("authenticationMethod", this.authenticationMethod == null ? null : this.authenticationMethod.toString());
        jsonWriter.writeStringField("initialCassandraAdminPassword", this.initialCassandraAdminPassword);
        jsonWriter.writeJsonField("prometheusEndpoint", this.prometheusEndpoint);
        jsonWriter.writeBooleanField("repairEnabled", this.repairEnabled);
        jsonWriter.writeArrayField("clientCertificates", this.clientCertificates, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("externalGossipCertificates", this.externalGossipCertificates, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("externalSeedNodes", this.externalSeedNodes, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("hoursBetweenBackups", this.hoursBetweenBackups);
        jsonWriter.writeBooleanField("deallocated", this.deallocated);
        jsonWriter.writeBooleanField("cassandraAuditLoggingEnabled", this.cassandraAuditLoggingEnabled);
        jsonWriter.writeJsonField("provisionError", this.provisionError);
        jsonWriter.writeStringField("azureConnectionMethod", this.azureConnectionMethod == null ? null : this.azureConnectionMethod.toString());
        return jsonWriter.writeEndObject();
    }

    public static ClusterResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterResourceProperties deserializedClusterResourceProperties = new ClusterResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterResourceProperties.provisioningState = ManagedCassandraProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("restoreFromBackupId".equals(fieldName)) {
                    deserializedClusterResourceProperties.restoreFromBackupId = reader.getString();
                    continue;
                }
                if ("delegatedManagementSubnetId".equals(fieldName)) {
                    deserializedClusterResourceProperties.delegatedManagementSubnetId = reader.getString();
                    continue;
                }
                if ("cassandraVersion".equals(fieldName)) {
                    deserializedClusterResourceProperties.cassandraVersion = reader.getString();
                    continue;
                }
                if ("clusterNameOverride".equals(fieldName)) {
                    deserializedClusterResourceProperties.clusterNameOverride = reader.getString();
                    continue;
                }
                if ("authenticationMethod".equals(fieldName)) {
                    deserializedClusterResourceProperties.authenticationMethod = AuthenticationMethod.fromString(reader.getString());
                    continue;
                }
                if ("initialCassandraAdminPassword".equals(fieldName)) {
                    deserializedClusterResourceProperties.initialCassandraAdminPassword = reader.getString();
                    continue;
                }
                if ("prometheusEndpoint".equals(fieldName)) {
                    deserializedClusterResourceProperties.prometheusEndpoint = SeedNode.fromJson(reader);
                    continue;
                }
                if ("repairEnabled".equals(fieldName)) {
                    deserializedClusterResourceProperties.repairEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clientCertificates".equals(fieldName)) {
                    List<Certificate> clientCertificates = reader.readArray(reader1 -> Certificate.fromJson(reader1));
                    deserializedClusterResourceProperties.clientCertificates = clientCertificates;
                    continue;
                }
                if ("externalGossipCertificates".equals(fieldName)) {
                    List<Certificate> externalGossipCertificates = reader.readArray(reader1 -> Certificate.fromJson(reader1));
                    deserializedClusterResourceProperties.externalGossipCertificates = externalGossipCertificates;
                    continue;
                }
                if ("gossipCertificates".equals(fieldName)) {
                    List<Certificate> gossipCertificates = reader.readArray(reader1 -> Certificate.fromJson(reader1));
                    deserializedClusterResourceProperties.gossipCertificates = gossipCertificates;
                    continue;
                }
                if ("externalSeedNodes".equals(fieldName)) {
                    List<SeedNode> externalSeedNodes = reader.readArray(reader1 -> SeedNode.fromJson(reader1));
                    deserializedClusterResourceProperties.externalSeedNodes = externalSeedNodes;
                    continue;
                }
                if ("seedNodes".equals(fieldName)) {
                    List<SeedNode> seedNodes = reader.readArray(reader1 -> SeedNode.fromJson(reader1));
                    deserializedClusterResourceProperties.seedNodes = seedNodes;
                    continue;
                }
                if ("hoursBetweenBackups".equals(fieldName)) {
                    deserializedClusterResourceProperties.hoursBetweenBackups = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("deallocated".equals(fieldName)) {
                    deserializedClusterResourceProperties.deallocated = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("cassandraAuditLoggingEnabled".equals(fieldName)) {
                    deserializedClusterResourceProperties.cassandraAuditLoggingEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisionError".equals(fieldName)) {
                    deserializedClusterResourceProperties.provisionError = CassandraError.fromJson(reader);
                    continue;
                }
                if ("azureConnectionMethod".equals(fieldName)) {
                    deserializedClusterResourceProperties.azureConnectionMethod = AzureConnectionType.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkResourceId".equals(fieldName)) {
                    deserializedClusterResourceProperties.privateLinkResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterResourceProperties;
        });
    }
}

