/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ClientEncryptionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ComputedProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.SqlContainerResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.VectorEmbeddingPolicy;
import java.io.IOException;
import java.util.List;

public final class RestorableSqlContainerPropertiesResourceContainer
extends SqlContainerResource {
    private String self;
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(RestorableSqlContainerPropertiesResourceContainer.class);

    public String self() {
        return this.self;
    }

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withIndexingPolicy(IndexingPolicy indexingPolicy) {
        super.withIndexingPolicy(indexingPolicy);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withPartitionKey(ContainerPartitionKey partitionKey) {
        super.withPartitionKey(partitionKey);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        super.withUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        super.withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        super.withClientEncryptionPolicy(clientEncryptionPolicy);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withComputedProperties(List<ComputedProperty> computedProperties) {
        super.withComputedProperties(computedProperties);
        return this;
    }

    @Override
    public RestorableSqlContainerPropertiesResourceContainer withVectorEmbeddingPolicy(VectorEmbeddingPolicy vectorEmbeddingPolicy) {
        super.withVectorEmbeddingPolicy(vectorEmbeddingPolicy);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model RestorableSqlContainerPropertiesResourceContainer"));
        }
        if (this.indexingPolicy() != null) {
            this.indexingPolicy().validate();
        }
        if (this.partitionKey() != null) {
            this.partitionKey().validate();
        }
        if (this.uniqueKeyPolicy() != null) {
            this.uniqueKeyPolicy().validate();
        }
        if (this.conflictResolutionPolicy() != null) {
            this.conflictResolutionPolicy().validate();
        }
        if (this.clientEncryptionPolicy() != null) {
            this.clientEncryptionPolicy().validate();
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
        if (this.computedProperties() != null) {
            this.computedProperties().forEach(e -> e.validate());
        }
        if (this.vectorEmbeddingPolicy() != null) {
            this.vectorEmbeddingPolicy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("indexingPolicy", this.indexingPolicy());
        jsonWriter.writeJsonField("partitionKey", this.partitionKey());
        jsonWriter.writeNumberField("defaultTtl", this.defaultTtl());
        jsonWriter.writeJsonField("uniqueKeyPolicy", this.uniqueKeyPolicy());
        jsonWriter.writeJsonField("conflictResolutionPolicy", this.conflictResolutionPolicy());
        jsonWriter.writeJsonField("clientEncryptionPolicy", this.clientEncryptionPolicy());
        jsonWriter.writeNumberField("analyticalStorageTtl", this.analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters());
        jsonWriter.writeStringField("createMode", this.createMode() == null ? null : this.createMode().toString());
        jsonWriter.writeArrayField("computedProperties", this.computedProperties(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("vectorEmbeddingPolicy", this.vectorEmbeddingPolicy());
        return jsonWriter.writeEndObject();
    }

    public static RestorableSqlContainerPropertiesResourceContainer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableSqlContainerPropertiesResourceContainer deserializedRestorableSqlContainerPropertiesResourceContainer = new RestorableSqlContainerPropertiesResourceContainer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withId(reader.getString());
                    continue;
                }
                if ("indexingPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withIndexingPolicy(IndexingPolicy.fromJson(reader));
                    continue;
                }
                if ("partitionKey".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withPartitionKey(ContainerPartitionKey.fromJson(reader));
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withDefaultTtl(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withUniqueKeyPolicy(UniqueKeyPolicy.fromJson(reader));
                    continue;
                }
                if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withConflictResolutionPolicy(ConflictResolutionPolicy.fromJson(reader));
                    continue;
                }
                if ("clientEncryptionPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withClientEncryptionPolicy(ClientEncryptionPolicy.fromJson(reader));
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withAnalyticalStorageTtl(reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withCreateMode(CreateMode.fromString(reader.getString()));
                    continue;
                }
                if ("computedProperties".equals(fieldName)) {
                    List<ComputedProperty> computedProperties = reader.readArray(reader1 -> ComputedProperty.fromJson(reader1));
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withComputedProperties((List)computedProperties);
                    continue;
                }
                if ("vectorEmbeddingPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withVectorEmbeddingPolicy(VectorEmbeddingPolicy.fromJson(reader));
                    continue;
                }
                if ("_self".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.self = reader.getString();
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.ts = reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableSqlContainerPropertiesResourceContainer;
        });
    }
}

