/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.ZoneType;
import java.io.IOException;
import java.util.List;

public final class ZoneProperties
implements JsonSerializable<ZoneProperties> {
    private Long maxNumberOfRecordSets;
    private Long maxNumberOfRecordsPerRecordSet;
    private Long numberOfRecordSets;
    private List<String> nameServers;
    private ZoneType zoneType;
    private List<SubResource> registrationVirtualNetworks;
    private List<SubResource> resolutionVirtualNetworks;

    public Long maxNumberOfRecordSets() {
        return this.maxNumberOfRecordSets;
    }

    public Long maxNumberOfRecordsPerRecordSet() {
        return this.maxNumberOfRecordsPerRecordSet;
    }

    public Long numberOfRecordSets() {
        return this.numberOfRecordSets;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public ZoneType zoneType() {
        return this.zoneType;
    }

    public ZoneProperties withZoneType(ZoneType zoneType) {
        this.zoneType = zoneType;
        return this;
    }

    public List<SubResource> registrationVirtualNetworks() {
        return this.registrationVirtualNetworks;
    }

    public ZoneProperties withRegistrationVirtualNetworks(List<SubResource> registrationVirtualNetworks) {
        this.registrationVirtualNetworks = registrationVirtualNetworks;
        return this;
    }

    public List<SubResource> resolutionVirtualNetworks() {
        return this.resolutionVirtualNetworks;
    }

    public ZoneProperties withResolutionVirtualNetworks(List<SubResource> resolutionVirtualNetworks) {
        this.resolutionVirtualNetworks = resolutionVirtualNetworks;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("zoneType", this.zoneType == null ? null : this.zoneType.toString());
        jsonWriter.writeArrayField("registrationVirtualNetworks", this.registrationVirtualNetworks, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("resolutionVirtualNetworks", this.resolutionVirtualNetworks, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ZoneProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ZoneProperties deserializedZoneProperties = new ZoneProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxNumberOfRecordSets".equals(fieldName)) {
                    deserializedZoneProperties.maxNumberOfRecordSets = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maxNumberOfRecordsPerRecordSet".equals(fieldName)) {
                    deserializedZoneProperties.maxNumberOfRecordsPerRecordSet = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("numberOfRecordSets".equals(fieldName)) {
                    deserializedZoneProperties.numberOfRecordSets = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nameServers".equals(fieldName)) {
                    List<String> nameServers = reader.readArray(reader1 -> reader1.getString());
                    deserializedZoneProperties.nameServers = nameServers;
                    continue;
                }
                if ("zoneType".equals(fieldName)) {
                    deserializedZoneProperties.zoneType = ZoneType.fromString(reader.getString());
                    continue;
                }
                if ("registrationVirtualNetworks".equals(fieldName)) {
                    List<SubResource> registrationVirtualNetworks = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedZoneProperties.registrationVirtualNetworks = registrationVirtualNetworks;
                    continue;
                }
                if ("resolutionVirtualNetworks".equals(fieldName)) {
                    List<SubResource> resolutionVirtualNetworks = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedZoneProperties.resolutionVirtualNetworks = resolutionVirtualNetworks;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedZoneProperties;
        });
    }
}

