/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.management.serializer.SerializerFactory;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsManagementClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={DnsManagementClientImpl.class})
public final class DnsManagementClientBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public DnsManagementClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public DnsManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public DnsManagementClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public DnsManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public DnsManagementClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public DnsManagementClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public DnsManagementClientImpl buildClient() {
        String localEndpoint = this.endpoint != null ? this.endpoint : "https://management.azure.com";
        AzureEnvironment localEnvironment = this.environment != null ? this.environment : AzureEnvironment.AZURE;
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build();
        Duration localDefaultPollInterval = this.defaultPollInterval != null ? this.defaultPollInterval : Duration.ofSeconds(30L);
        SerializerAdapter localSerializerAdapter = this.serializerAdapter != null ? this.serializerAdapter : SerializerFactory.createDefaultManagementSerializerAdapter();
        DnsManagementClientImpl client = new DnsManagementClientImpl(localPipeline, localSerializerAdapter, localDefaultPollInterval, localEnvironment, this.subscriptionId, localEndpoint);
        return client;
    }
}

