/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.EventhubInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.EventHubImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHub;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.WrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public final class EventHubsImpl
extends WrapperImpl<EventHubsClient>
implements EventHubs {
    private final EventHubsManager manager;
    private final StorageManager storageManager;

    public EventHubsImpl(EventHubsManager manager, StorageManager storageManager) {
        super(((EventHubManagementClient)manager.serviceClient()).getEventHubs());
        this.manager = manager;
        this.storageManager = storageManager;
    }

    @Override
    public EventHubsManager manager() {
        return this.manager;
    }

    @Override
    public EventHubImpl define(String name) {
        return new EventHubImpl(name, this.manager, this.storageManager);
    }

    @Override
    public EventHubAuthorizationRules authorizationRules() {
        return this.manager().eventHubAuthorizationRules();
    }

    @Override
    public EventHubConsumerGroups consumerGroups() {
        return this.manager().consumerGroups();
    }

    @Override
    public EventHub getById(String id) {
        return this.getByIdAsync(id).block();
    }

    @Override
    public Mono<EventHub> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString(id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Mono<EventHub> getByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((EventHubsClient)this.innerModel()).getAsync(resourceGroupName, namespaceName, name).map(this::wrapModel);
    }

    @Override
    public EventHub getByName(String resourceGroupName, String namespaceName, String name) {
        return this.getByNameAsync(resourceGroupName, namespaceName, name).block();
    }

    @Override
    public PagedIterable<EventHub> listByNamespace(String resourceGroupName, String namespaceName) {
        return PagedConverter.mapPage(((EventHubsClient)this.innerModel()).listByNamespace(resourceGroupName, namespaceName), this::wrapModel);
    }

    @Override
    public PagedFlux<EventHub> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        return PagedConverter.mapPage(((EventHubsClient)this.innerModel()).listByNamespaceAsync(resourceGroupName, namespaceName), this::wrapModel);
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString(id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Mono<Void> deleteByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((EventHubsClient)this.innerModel()).deleteAsync(resourceGroupName, namespaceName, name);
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, name).block();
    }

    private EventHubImpl wrapModel(EventhubInner innerModel) {
        return new EventHubImpl(innerModel.name(), innerModel, this.manager, this.storageManager);
    }
}

