/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.DestinationProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.CaptureIdentity;
import java.io.IOException;
import java.util.UUID;

public final class Destination
implements JsonSerializable<Destination> {
    private String name;
    private CaptureIdentity identity;
    private DestinationProperties innerProperties;

    public String name() {
        return this.name;
    }

    public Destination withName(String name) {
        this.name = name;
        return this;
    }

    public CaptureIdentity identity() {
        return this.identity;
    }

    public Destination withIdentity(CaptureIdentity identity) {
        this.identity = identity;
        return this;
    }

    private DestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String storageAccountResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountResourceId();
    }

    public Destination withStorageAccountResourceId(String storageAccountResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withStorageAccountResourceId(storageAccountResourceId);
        return this;
    }

    public String blobContainer() {
        return this.innerProperties() == null ? null : this.innerProperties().blobContainer();
    }

    public Destination withBlobContainer(String blobContainer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withBlobContainer(blobContainer);
        return this;
    }

    public String archiveNameFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().archiveNameFormat();
    }

    public Destination withArchiveNameFormat(String archiveNameFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withArchiveNameFormat(archiveNameFormat);
        return this;
    }

    public UUID dataLakeSubscriptionId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataLakeSubscriptionId();
    }

    public Destination withDataLakeSubscriptionId(UUID dataLakeSubscriptionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withDataLakeSubscriptionId(dataLakeSubscriptionId);
        return this;
    }

    public String dataLakeAccountName() {
        return this.innerProperties() == null ? null : this.innerProperties().dataLakeAccountName();
    }

    public Destination withDataLakeAccountName(String dataLakeAccountName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withDataLakeAccountName(dataLakeAccountName);
        return this;
    }

    public String dataLakeFolderPath() {
        return this.innerProperties() == null ? null : this.innerProperties().dataLakeFolderPath();
    }

    public Destination withDataLakeFolderPath(String dataLakeFolderPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DestinationProperties();
        }
        this.innerProperties().withDataLakeFolderPath(dataLakeFolderPath);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static Destination fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Destination deserializedDestination = new Destination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDestination.name = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedDestination.identity = CaptureIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDestination.innerProperties = DestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDestination;
        });
    }
}

