/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Secret;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vault;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.SecretProperties;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Map;
import java.util.Objects;

class SecretImpl
extends CreatableUpdatableImpl<Secret, SecretProperties, SecretImpl>
implements Secret,
Secret.Definition,
Secret.Update {
    private final Vault vault;
    private String secretValueToSet;
    private String secretValue;

    SecretImpl(String name, SecretProperties innerObject, Vault vault) {
        super(name, innerObject);
        this.vault = vault;
    }

    SecretImpl(String name, KeyVaultSecret keyVaultSecret, Vault vault) {
        super(name, keyVaultSecret.getProperties());
        this.secretValue = keyVaultSecret.getValue();
        this.vault = vault;
    }

    private SecretImpl wrapModel(SecretProperties secret) {
        return new SecretImpl(secret.getName(), secret, this.vault);
    }

    @Override
    public String id() {
        return ((SecretProperties)this.innerModel()).getId();
    }

    @Override
    public String getValue() {
        return this.getValueAsync().block();
    }

    @Override
    public Mono<String> getValueAsync() {
        if (this.secretValue != null) {
            return Mono.just(this.secretValue);
        }
        return this.getInnerAsync().map(ignored -> this.secretValue);
    }

    @Override
    public SecretProperties attributes() {
        return (SecretProperties)this.innerModel();
    }

    @Override
    public Map<String, String> tags() {
        return ((SecretProperties)this.innerModel()).getTags();
    }

    @Override
    public String contentType() {
        return ((SecretProperties)this.innerModel()).getContentType();
    }

    @Override
    public String kid() {
        return ((SecretProperties)this.innerModel()).getKeyId();
    }

    @Override
    public boolean managed() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SecretProperties)this.innerModel()).isManaged());
    }

    @Override
    public boolean enabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SecretProperties)this.innerModel()).isEnabled());
    }

    @Override
    public PagedIterable<Secret> listVersions() {
        return new PagedIterable<Secret>(this.listVersionsAsync());
    }

    @Override
    public PagedFlux<Secret> listVersionsAsync() {
        return PagedConverter.mapPage(this.vault.secretClient().listPropertiesOfSecretVersions(this.name()), this::wrapModel);
    }

    @Override
    protected Mono<SecretProperties> getInnerAsync() {
        return this.vault.secretClient().getSecret(this.name(), ((SecretProperties)this.innerModel()).getVersion()).map(secret -> {
            this.secretValue = secret.getValue();
            return secret.getProperties();
        });
    }

    @Override
    public SecretImpl withTags(Map<String, String> tags) {
        ((SecretProperties)this.innerModel()).setTags(tags);
        return this;
    }

    @Override
    public boolean isInCreateMode() {
        return this.id() == null;
    }

    @Override
    public Mono<Secret> createResourceAsync() {
        KeyVaultSecret newSecret = new KeyVaultSecret(this.name(), this.secretValueToSet);
        newSecret.setProperties(this.attributes());
        return this.vault.secretClient().setSecret(newSecret).map(keyVaultSecret -> {
            this.setInner(keyVaultSecret.getProperties());
            this.secretValue = keyVaultSecret.getValue();
            this.secretValueToSet = null;
            return this;
        });
    }

    @Override
    public Mono<Secret> updateResourceAsync() {
        if (this.secretValueToSet == null) {
            return this.vault.secretClient().updateSecretProperties((SecretProperties)this.innerModel()).map(p -> {
                this.setInner(p);
                if (!p.isEnabled().booleanValue()) {
                    this.secretValue = null;
                }
                return this;
            });
        }
        return this.createResourceAsync();
    }

    @Override
    public SecretImpl withAttributes(SecretProperties attributes) {
        this.setInner(attributes);
        return this;
    }

    @Override
    public SecretImpl withValue(String value) {
        Objects.requireNonNull(value);
        this.secretValueToSet = value;
        return this;
    }

    @Override
    public SecretImpl withContentType(String contentType) {
        ((SecretProperties)this.innerModel()).setContentType(contentType);
        return this;
    }
}

