/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Base64Url;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class KeyReleasePolicy
implements JsonSerializable<KeyReleasePolicy> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private String contentType;
    private Base64Url data;

    public String contentType() {
        return this.contentType;
    }

    public KeyReleasePolicy withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public byte[] data() {
        if (this.data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.data.decodedBytes();
    }

    public KeyReleasePolicy withData(byte[] data) {
        this.data = data == null ? null : Base64Url.encode(CoreUtils.clone(data));
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("data", Objects.toString(this.data, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyReleasePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyReleasePolicy deserializedKeyReleasePolicy = new KeyReleasePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedKeyReleasePolicy.contentType = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedKeyReleasePolicy.data = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyReleasePolicy;
        });
    }
}

