/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.TimeSeriesBaseline;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class MetricBaselinesProperties
implements JsonSerializable<MetricBaselinesProperties> {
    private String timespan;
    private Duration interval;
    private String namespace;
    private List<TimeSeriesBaseline> baselines;
    private static final ClientLogger LOGGER = new ClientLogger(MetricBaselinesProperties.class);

    public String timespan() {
        return this.timespan;
    }

    public MetricBaselinesProperties withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    public Duration interval() {
        return this.interval;
    }

    public MetricBaselinesProperties withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public MetricBaselinesProperties withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public List<TimeSeriesBaseline> baselines() {
        return this.baselines;
    }

    public MetricBaselinesProperties withBaselines(List<TimeSeriesBaseline> baselines) {
        this.baselines = baselines;
        return this;
    }

    public void validate() {
        if (this.timespan() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property timespan in model MetricBaselinesProperties"));
        }
        if (this.interval() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property interval in model MetricBaselinesProperties"));
        }
        if (this.baselines() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property baselines in model MetricBaselinesProperties"));
        }
        this.baselines().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays(this.interval));
        jsonWriter.writeArrayField("baselines", this.baselines, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("namespace", this.namespace);
        return jsonWriter.writeEndObject();
    }

    public static MetricBaselinesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricBaselinesProperties deserializedMetricBaselinesProperties = new MetricBaselinesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timespan".equals(fieldName)) {
                    deserializedMetricBaselinesProperties.timespan = reader.getString();
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedMetricBaselinesProperties.interval = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("baselines".equals(fieldName)) {
                    List<TimeSeriesBaseline> baselines = reader.readArray(reader1 -> TimeSeriesBaseline.fromJson(reader1));
                    deserializedMetricBaselinesProperties.baselines = baselines;
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedMetricBaselinesProperties.namespace = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricBaselinesProperties;
        });
    }
}

