/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.DataCollectionRuleAssociationsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.DataCollectionRuleAssociationProxyOnlyResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataCollectionRuleAssociationProxyOnlyResourceListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class DataCollectionRuleAssociationsClientImpl
implements InnerSupportsDelete<Void>,
DataCollectionRuleAssociationsClient {
    private final DataCollectionRuleAssociationsService service;
    private final MonitorClientImpl client;

    DataCollectionRuleAssociationsClientImpl(MonitorClientImpl client) {
        this.service = RestProxy.create(DataCollectionRuleAssociationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByResourceSinglePageAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResource(this.client.getEndpoint(), resourceUri, "2021-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByResourceSinglePageAsync(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResource(this.client.getEndpoint(), resourceUri, "2021-09-01-preview", "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner> listByResourceAsync(String resourceUri) {
        return new PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner>(() -> this.listByResourceSinglePageAsync(resourceUri), nextLink -> this.listByResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner> listByResourceAsync(String resourceUri, Context context) {
        return new PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner>(() -> this.listByResourceSinglePageAsync(resourceUri, context), nextLink -> this.listByResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner> listByResource(String resourceUri) {
        return new PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner>(this.listByResourceAsync(resourceUri));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner> listByResource(String resourceUri, Context context) {
        return new PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner>(this.listByResourceAsync(resourceUri, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByRuleSinglePageAsync(String resourceGroupName, String dataCollectionRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByRule(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionRuleName, "2021-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByRuleSinglePageAsync(String resourceGroupName, String dataCollectionRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByRule(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionRuleName, "2021-09-01-preview", "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner> listByRuleAsync(String resourceGroupName, String dataCollectionRuleName) {
        return new PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner>(() -> this.listByRuleSinglePageAsync(resourceGroupName, dataCollectionRuleName), nextLink -> this.listByRuleNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner> listByRuleAsync(String resourceGroupName, String dataCollectionRuleName, Context context) {
        return new PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner>(() -> this.listByRuleSinglePageAsync(resourceGroupName, dataCollectionRuleName, context), nextLink -> this.listByRuleNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner> listByRule(String resourceGroupName, String dataCollectionRuleName) {
        return new PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner>(this.listByRuleAsync(resourceGroupName, dataCollectionRuleName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner> listByRule(String resourceGroupName, String dataCollectionRuleName, Context context) {
        return new PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner>(this.listByRuleAsync(resourceGroupName, dataCollectionRuleName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByDataCollectionEndpointSinglePageAsync(String resourceGroupName, String dataCollectionEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDataCollectionEndpoint(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByDataCollectionEndpointSinglePageAsync(String resourceGroupName, String dataCollectionEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionEndpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCollectionEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDataCollectionEndpoint(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dataCollectionEndpointName, "2021-09-01-preview", "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner> listByDataCollectionEndpointAsync(String resourceGroupName, String dataCollectionEndpointName) {
        return new PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner>(() -> this.listByDataCollectionEndpointSinglePageAsync(resourceGroupName, dataCollectionEndpointName), nextLink -> this.listByDataCollectionEndpointNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner> listByDataCollectionEndpointAsync(String resourceGroupName, String dataCollectionEndpointName, Context context) {
        return new PagedFlux<DataCollectionRuleAssociationProxyOnlyResourceInner>(() -> this.listByDataCollectionEndpointSinglePageAsync(resourceGroupName, dataCollectionEndpointName, context), nextLink -> this.listByDataCollectionEndpointNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner> listByDataCollectionEndpoint(String resourceGroupName, String dataCollectionEndpointName) {
        return new PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner>(this.listByDataCollectionEndpointAsync(resourceGroupName, dataCollectionEndpointName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner> listByDataCollectionEndpoint(String resourceGroupName, String dataCollectionEndpointName, Context context) {
        return new PagedIterable<DataCollectionRuleAssociationProxyOnlyResourceInner>(this.listByDataCollectionEndpointAsync(resourceGroupName, dataCollectionEndpointName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceInner>> getWithResponseAsync(String resourceUri, String associationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceUri, associationName, "2021-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceInner>> getWithResponseAsync(String resourceUri, String associationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceUri, associationName, "2021-09-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataCollectionRuleAssociationProxyOnlyResourceInner> getAsync(String resourceUri, String associationName) {
        return this.getWithResponseAsync(resourceUri, associationName).flatMap(res -> Mono.justOrEmpty((DataCollectionRuleAssociationProxyOnlyResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataCollectionRuleAssociationProxyOnlyResourceInner> getWithResponse(String resourceUri, String associationName, Context context) {
        return this.getWithResponseAsync(resourceUri, associationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataCollectionRuleAssociationProxyOnlyResourceInner get(String resourceUri, String associationName) {
        return this.getWithResponse(resourceUri, associationName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceInner>> createWithResponseAsync(String resourceUri, String associationName, DataCollectionRuleAssociationProxyOnlyResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceUri, associationName, "2021-09-01-preview", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceInner>> createWithResponseAsync(String resourceUri, String associationName, DataCollectionRuleAssociationProxyOnlyResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceUri, associationName, "2021-09-01-preview", body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataCollectionRuleAssociationProxyOnlyResourceInner> createAsync(String resourceUri, String associationName) {
        DataCollectionRuleAssociationProxyOnlyResourceInner body = null;
        return this.createWithResponseAsync(resourceUri, associationName, body).flatMap(res -> Mono.justOrEmpty((DataCollectionRuleAssociationProxyOnlyResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataCollectionRuleAssociationProxyOnlyResourceInner> createWithResponse(String resourceUri, String associationName, DataCollectionRuleAssociationProxyOnlyResourceInner body, Context context) {
        return this.createWithResponseAsync(resourceUri, associationName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataCollectionRuleAssociationProxyOnlyResourceInner create(String resourceUri, String associationName) {
        DataCollectionRuleAssociationProxyOnlyResourceInner body = null;
        return this.createWithResponse(resourceUri, associationName, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceUri, String associationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceUri, associationName, "2021-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceUri, String associationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (associationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter associationName is required and cannot be null."));
        }
        String apiVersion = "2021-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceUri, associationName, "2021-09-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceUri, String associationName) {
        return this.deleteWithResponseAsync(resourceUri, associationName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceUri, String associationName, Context context) {
        return this.deleteWithResponseAsync(resourceUri, associationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceUri, String associationName) {
        this.deleteWithResponse(resourceUri, associationName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByRuleNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByRuleNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByRuleNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByRuleNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByDataCollectionEndpointNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDataCollectionEndpointNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleAssociationProxyOnlyResourceInner>> listByDataCollectionEndpointNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDataCollectionEndpointNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DataCollectionRuleAssociationProxyOnlyResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).value(), ((DataCollectionRuleAssociationProxyOnlyResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientDataCol")
    public static interface DataCollectionRuleAssociationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceListResult>> listByResource(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dataCollectionRuleName}/associations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceListResult>> listByRule(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dataCollectionRuleName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}/associations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceListResult>> listByDataCollectionEndpoint(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dataCollectionEndpointName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @PathParam(value="associationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @PathParam(value="associationName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DataCollectionRuleAssociationProxyOnlyResourceInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @PathParam(value="associationName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceListResult>> listByResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceListResult>> listByRuleNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataCollectionRuleAssociationProxyOnlyResourceListResult>> listByDataCollectionEndpointNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

