/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.MonitorManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.MetricAlertResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MetricAlertConditionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MetricDynamicAlertConditionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DynamicMetricCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlert;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertCondition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertMultipleResourceMultipleMetricCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertSingleResourceMultipleMetricCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricDynamicAlertCondition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MultiMetricCriteria;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class MetricAlertImpl
extends GroupableResourceImpl<MetricAlert, MetricAlertResourceInner, MetricAlertImpl, MonitorManager>
implements MetricAlert,
MetricAlert.Definition,
MetricAlert.DefinitionMultipleResource,
MetricAlert.Update,
MetricAlert.UpdateStages.WithMetricUpdate {
    private final ClientLogger logger;
    private Map<String, MetricAlertCondition> conditions;
    private Map<String, MetricDynamicAlertCondition> dynamicConditions;
    private boolean multipleResource;

    MetricAlertImpl(String name, MetricAlertResourceInner innerModel, MonitorManager monitorManager) {
        block5: {
            MetricAlertCriteria innerCriteria;
            block6: {
                super(name, innerModel, monitorManager);
                this.logger = new ClientLogger(this.getClass());
                this.multipleResource = false;
                this.conditions = new TreeMap<String, MetricAlertCondition>();
                this.dynamicConditions = new TreeMap<String, MetricDynamicAlertCondition>();
                if (innerModel.criteria() == null) break block5;
                innerCriteria = innerModel.criteria();
                if (!(innerCriteria instanceof MetricAlertSingleResourceMultipleMetricCriteria)) break block6;
                this.multipleResource = false;
                MetricAlertSingleResourceMultipleMetricCriteria crits = (MetricAlertSingleResourceMultipleMetricCriteria)innerCriteria;
                List<MetricCriteria> criteria = crits.allOf();
                if (criteria == null) break block5;
                for (MetricCriteria crit : criteria) {
                    this.conditions.put(crit.name(), new MetricAlertConditionImpl(crit.name(), crit, this));
                }
                break block5;
            }
            if (innerCriteria instanceof MetricAlertMultipleResourceMultipleMetricCriteria) {
                this.multipleResource = true;
                MetricAlertMultipleResourceMultipleMetricCriteria crits = (MetricAlertMultipleResourceMultipleMetricCriteria)innerCriteria;
                List<MultiMetricCriteria> criteria = crits.allOf();
                if (criteria != null) {
                    for (MultiMetricCriteria crit : criteria) {
                        if (crit instanceof MetricCriteria) {
                            this.conditions.put(crit.name(), new MetricAlertConditionImpl(crit.name(), (MetricCriteria)crit, this));
                            continue;
                        }
                        if (!(crit instanceof DynamicMetricCriteria)) continue;
                        this.dynamicConditions.put(crit.name(), new MetricDynamicAlertConditionImpl(crit.name(), (DynamicMetricCriteria)crit, this));
                    }
                }
            }
        }
    }

    @Override
    public Mono<MetricAlert> createResourceAsync() {
        if (this.conditions.isEmpty() && this.dynamicConditions.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Condition cannot be empty"));
        }
        if (!this.conditions.isEmpty() && !this.dynamicConditions.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Static condition and dynamic condition cannot co-exist"));
        }
        ((MetricAlertResourceInner)this.innerModel()).withLocation("global");
        if (!this.conditions.isEmpty()) {
            if (!this.multipleResource) {
                MetricAlertSingleResourceMultipleMetricCriteria crit = new MetricAlertSingleResourceMultipleMetricCriteria();
                crit.withAllOf(new ArrayList<MetricCriteria>());
                for (MetricAlertCondition mc : this.conditions.values()) {
                    crit.allOf().add((MetricCriteria)mc.innerModel());
                }
                ((MetricAlertResourceInner)this.innerModel()).withCriteria(crit);
            } else {
                MetricAlertMultipleResourceMultipleMetricCriteria crit = new MetricAlertMultipleResourceMultipleMetricCriteria();
                crit.withAllOf(new ArrayList<MultiMetricCriteria>());
                for (MetricAlertCondition mc : this.conditions.values()) {
                    crit.allOf().add((MultiMetricCriteria)mc.innerModel());
                }
                ((MetricAlertResourceInner)this.innerModel()).withCriteria(crit);
            }
        } else if (!this.dynamicConditions.isEmpty()) {
            MetricAlertMultipleResourceMultipleMetricCriteria crit = new MetricAlertMultipleResourceMultipleMetricCriteria();
            crit.withAllOf(new ArrayList<MultiMetricCriteria>());
            for (MetricDynamicAlertCondition mc : this.dynamicConditions.values()) {
                crit.allOf().add((MultiMetricCriteria)mc.innerModel());
            }
            ((MetricAlertResourceInner)this.innerModel()).withCriteria(crit);
        }
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getMetricAlerts().createOrUpdateAsync(this.resourceGroupName(), this.name(), (MetricAlertResourceInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<MetricAlertResourceInner> getInnerAsync() {
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getMetricAlerts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public MetricAlertImpl withTargetResource(String resourceId) {
        this.multipleResource = false;
        ((MetricAlertResourceInner)this.innerModel()).withScopes(new ArrayList<String>());
        ((MetricAlertResourceInner)this.innerModel()).scopes().add(resourceId);
        return this;
    }

    @Override
    public MetricAlertImpl withTargetResource(HasId resource) {
        this.multipleResource = false;
        return this.withTargetResource(resource.id());
    }

    @Override
    public MetricAlertImpl withPeriod(Duration size) {
        ((MetricAlertResourceInner)this.innerModel()).withWindowSize(size);
        return this;
    }

    @Override
    public MetricAlertImpl withFrequency(Duration frequency) {
        ((MetricAlertResourceInner)this.innerModel()).withEvaluationFrequency(frequency);
        return this;
    }

    @Override
    public MetricAlertImpl withSeverity(int severity) {
        ((MetricAlertResourceInner)this.innerModel()).withSeverity(severity);
        return this;
    }

    @Override
    public MetricAlertImpl withAlertDetails(int severity, String description) {
        this.withSeverity(severity);
        return this.withDescription(description);
    }

    @Override
    public MetricAlertImpl withDescription(String description) {
        ((MetricAlertResourceInner)this.innerModel()).withDescription(description);
        return this;
    }

    @Override
    public MetricAlertImpl withRuleEnabled() {
        ((MetricAlertResourceInner)this.innerModel()).withEnabled(true);
        return this;
    }

    @Override
    public MetricAlertImpl withRuleDisabled() {
        ((MetricAlertResourceInner)this.innerModel()).withEnabled(false);
        return this;
    }

    @Override
    public MetricAlertImpl withAutoMitigation() {
        ((MetricAlertResourceInner)this.innerModel()).withAutoMitigate(true);
        return this;
    }

    @Override
    public MetricAlertImpl withoutAutoMitigation() {
        ((MetricAlertResourceInner)this.innerModel()).withAutoMitigate(false);
        return this;
    }

    @Override
    public MetricAlertImpl withActionGroups(String ... actionGroupId) {
        if (((MetricAlertResourceInner)this.innerModel()).actions() == null) {
            ((MetricAlertResourceInner)this.innerModel()).withActions(new ArrayList<MetricAlertAction>());
        }
        ((MetricAlertResourceInner)this.innerModel()).actions().clear();
        for (String agid : actionGroupId) {
            MetricAlertAction maa = new MetricAlertAction();
            maa.withActionGroupId(agid);
            ((MetricAlertResourceInner)this.innerModel()).actions().add(maa);
        }
        return this;
    }

    @Override
    public MetricAlertImpl withoutActionGroup(String actionGroupId) {
        if (((MetricAlertResourceInner)this.innerModel()).actions() != null) {
            ArrayList<MetricAlertAction> toDelete = new ArrayList<MetricAlertAction>();
            for (MetricAlertAction maa : ((MetricAlertResourceInner)this.innerModel()).actions()) {
                if (!maa.actionGroupId().equalsIgnoreCase(actionGroupId)) continue;
                toDelete.add(maa);
            }
            ((MetricAlertResourceInner)this.innerModel()).actions().removeAll(toDelete);
        }
        return this;
    }

    public MetricAlertConditionImpl defineAlertCriteria(String name) {
        return new MetricAlertConditionImpl(name, new MetricCriteria(), this);
    }

    public MetricDynamicAlertConditionImpl defineDynamicAlertCriteria(String name) {
        return new MetricDynamicAlertConditionImpl(name, new DynamicMetricCriteria(), this);
    }

    @Override
    public MetricAlertConditionImpl updateAlertCriteria(String name) {
        return (MetricAlertConditionImpl)this.conditions.get(name);
    }

    @Override
    public MetricDynamicAlertConditionImpl updateDynamicAlertCriteria(String name) {
        return (MetricDynamicAlertConditionImpl)this.dynamicConditions.get(name);
    }

    @Override
    public MetricAlertImpl withoutAlertCriteria(String name) {
        if (this.conditions.containsKey(name)) {
            this.conditions.remove(name);
        }
        if (this.dynamicConditions.containsKey(name)) {
            this.dynamicConditions.remove(name);
        }
        return this;
    }

    MetricAlertImpl withAlertCriteria(MetricAlertConditionImpl criteria) {
        this.withoutAlertCriteria(criteria.name());
        this.conditions.put(criteria.name(), criteria);
        return this;
    }

    MetricAlertImpl withDynamicAlertCriteria(MetricDynamicAlertConditionImpl criteria) {
        this.withoutAlertCriteria(criteria.name());
        this.dynamicConditions.put(criteria.name(), criteria);
        return this;
    }

    @Override
    public MetricAlertImpl withMultipleTargetResources(Collection<String> resourceIds, String type, String region) {
        if (resourceIds == null || resourceIds.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Target resource cannot be empty"));
        }
        this.multipleResource = true;
        ((MetricAlertResourceInner)this.innerModel()).withScopes(new ArrayList<String>(resourceIds));
        ((MetricAlertResourceInner)this.innerModel()).withTargetResourceType(type);
        ((MetricAlertResourceInner)this.innerModel()).withTargetResourceRegion(region);
        return this;
    }

    @Override
    public MetricAlertImpl withMultipleTargetResources(Collection<? extends Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Target resource cannot be empty"));
        }
        this.multipleResource = true;
        ArrayList<String> resourceIds = new ArrayList<String>();
        String type = resources.iterator().next().type();
        String regionName = resources.iterator().next().regionName();
        for (Resource resource : resources) {
            if (!type.equalsIgnoreCase(resource.type()) || !regionName.equalsIgnoreCase(resource.regionName())) {
                throw this.logger.logExceptionAsError(new IllegalArgumentException("Target resource must be of the same resource type and in the same region"));
            }
            resourceIds.add(resource.id());
        }
        return this.withMultipleTargetResources(resourceIds, type, regionName);
    }

    @Override
    public String description() {
        return ((MetricAlertResourceInner)this.innerModel()).description();
    }

    @Override
    public int severity() {
        return ((MetricAlertResourceInner)this.innerModel()).severity();
    }

    @Override
    public boolean enabled() {
        return ((MetricAlertResourceInner)this.innerModel()).enabled();
    }

    @Override
    public Duration evaluationFrequency() {
        return ((MetricAlertResourceInner)this.innerModel()).evaluationFrequency();
    }

    @Override
    public Duration windowSize() {
        return ((MetricAlertResourceInner)this.innerModel()).windowSize();
    }

    @Override
    public boolean autoMitigate() {
        return ((MetricAlertResourceInner)this.innerModel()).autoMitigate();
    }

    @Override
    public OffsetDateTime lastUpdatedTime() {
        return ((MetricAlertResourceInner)this.innerModel()).lastUpdatedTime();
    }

    @Override
    public Collection<String> scopes() {
        return Collections.unmodifiableCollection(((MetricAlertResourceInner)this.innerModel()).scopes());
    }

    @Override
    public Collection<String> actionGroupIds() {
        if (((MetricAlertResourceInner)this.innerModel()).actions() != null && ((MetricAlertResourceInner)this.innerModel()).actions() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (MetricAlertAction maag : ((MetricAlertResourceInner)this.innerModel()).actions()) {
                ids.add(maag.actionGroupId());
            }
            return Collections.unmodifiableCollection(ids);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, MetricAlertCondition> alertCriterias() {
        return Collections.unmodifiableMap(this.conditions);
    }

    @Override
    public Map<String, MetricDynamicAlertCondition> dynamicAlertCriterias() {
        return Collections.unmodifiableMap(this.dynamicConditions);
    }
}

