/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.EmailNotification;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.WebhookNotification;
import java.io.IOException;
import java.util.List;

public final class AutoscaleNotification
implements JsonSerializable<AutoscaleNotification> {
    private String operation = "Scale";
    private EmailNotification email;
    private List<WebhookNotification> webhooks;

    public String operation() {
        return this.operation;
    }

    public AutoscaleNotification withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public EmailNotification email() {
        return this.email;
    }

    public AutoscaleNotification withEmail(EmailNotification email) {
        this.email = email;
        return this;
    }

    public List<WebhookNotification> webhooks() {
        return this.webhooks;
    }

    public AutoscaleNotification withWebhooks(List<WebhookNotification> webhooks) {
        this.webhooks = webhooks;
        return this;
    }

    public void validate() {
        if (this.email() != null) {
            this.email().validate();
        }
        if (this.webhooks() != null) {
            this.webhooks().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeJsonField("email", this.email);
        jsonWriter.writeArrayField("webhooks", this.webhooks, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AutoscaleNotification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoscaleNotification deserializedAutoscaleNotification = new AutoscaleNotification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("email".equals(fieldName)) {
                    deserializedAutoscaleNotification.email = EmailNotification.fromJson(reader);
                    continue;
                }
                if ("webhooks".equals(fieldName)) {
                    List<WebhookNotification> webhooks = reader.readArray(reader1 -> WebhookNotification.fromJson(reader1));
                    deserializedAutoscaleNotification.webhooks = webhooks;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoscaleNotification;
        });
    }
}

