/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ComparisonOperationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricStatisticType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ScaleRuleMetricDimension;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.TimeAggregationType;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class MetricTrigger
implements JsonSerializable<MetricTrigger> {
    private String metricName;
    private String metricNamespace;
    private String metricResourceUri;
    private String metricResourceLocation;
    private Duration timeGrain;
    private MetricStatisticType statistic;
    private Duration timeWindow;
    private TimeAggregationType timeAggregation;
    private ComparisonOperationType operator;
    private double threshold;
    private List<ScaleRuleMetricDimension> dimensions;
    private Boolean dividePerInstance;
    private static final ClientLogger LOGGER = new ClientLogger(MetricTrigger.class);

    public String metricName() {
        return this.metricName;
    }

    public MetricTrigger withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public MetricTrigger withMetricNamespace(String metricNamespace) {
        this.metricNamespace = metricNamespace;
        return this;
    }

    public String metricResourceUri() {
        return this.metricResourceUri;
    }

    public MetricTrigger withMetricResourceUri(String metricResourceUri) {
        this.metricResourceUri = metricResourceUri;
        return this;
    }

    public String metricResourceLocation() {
        return this.metricResourceLocation;
    }

    public MetricTrigger withMetricResourceLocation(String metricResourceLocation) {
        this.metricResourceLocation = metricResourceLocation;
        return this;
    }

    public Duration timeGrain() {
        return this.timeGrain;
    }

    public MetricTrigger withTimeGrain(Duration timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    public MetricStatisticType statistic() {
        return this.statistic;
    }

    public MetricTrigger withStatistic(MetricStatisticType statistic) {
        this.statistic = statistic;
        return this;
    }

    public Duration timeWindow() {
        return this.timeWindow;
    }

    public MetricTrigger withTimeWindow(Duration timeWindow) {
        this.timeWindow = timeWindow;
        return this;
    }

    public TimeAggregationType timeAggregation() {
        return this.timeAggregation;
    }

    public MetricTrigger withTimeAggregation(TimeAggregationType timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    public ComparisonOperationType operator() {
        return this.operator;
    }

    public MetricTrigger withOperator(ComparisonOperationType operator) {
        this.operator = operator;
        return this;
    }

    public double threshold() {
        return this.threshold;
    }

    public MetricTrigger withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public List<ScaleRuleMetricDimension> dimensions() {
        return this.dimensions;
    }

    public MetricTrigger withDimensions(List<ScaleRuleMetricDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Boolean dividePerInstance() {
        return this.dividePerInstance;
    }

    public MetricTrigger withDividePerInstance(Boolean dividePerInstance) {
        this.dividePerInstance = dividePerInstance;
        return this;
    }

    public void validate() {
        if (this.metricName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property metricName in model MetricTrigger"));
        }
        if (this.metricResourceUri() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property metricResourceUri in model MetricTrigger"));
        }
        if (this.timeGrain() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property timeGrain in model MetricTrigger"));
        }
        if (this.statistic() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property statistic in model MetricTrigger"));
        }
        if (this.timeWindow() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property timeWindow in model MetricTrigger"));
        }
        if (this.timeAggregation() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property timeAggregation in model MetricTrigger"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model MetricTrigger"));
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metricName", this.metricName);
        jsonWriter.writeStringField("metricResourceUri", this.metricResourceUri);
        jsonWriter.writeStringField("timeGrain", CoreUtils.durationToStringWithDays(this.timeGrain));
        jsonWriter.writeStringField("statistic", this.statistic == null ? null : this.statistic.toString());
        jsonWriter.writeStringField("timeWindow", CoreUtils.durationToStringWithDays(this.timeWindow));
        jsonWriter.writeStringField("timeAggregation", this.timeAggregation == null ? null : this.timeAggregation.toString());
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeDoubleField("threshold", this.threshold);
        jsonWriter.writeStringField("metricNamespace", this.metricNamespace);
        jsonWriter.writeStringField("metricResourceLocation", this.metricResourceLocation);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("dividePerInstance", this.dividePerInstance);
        return jsonWriter.writeEndObject();
    }

    public static MetricTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricTrigger deserializedMetricTrigger = new MetricTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metricName".equals(fieldName)) {
                    deserializedMetricTrigger.metricName = reader.getString();
                    continue;
                }
                if ("metricResourceUri".equals(fieldName)) {
                    deserializedMetricTrigger.metricResourceUri = reader.getString();
                    continue;
                }
                if ("timeGrain".equals(fieldName)) {
                    deserializedMetricTrigger.timeGrain = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("statistic".equals(fieldName)) {
                    deserializedMetricTrigger.statistic = MetricStatisticType.fromString(reader.getString());
                    continue;
                }
                if ("timeWindow".equals(fieldName)) {
                    deserializedMetricTrigger.timeWindow = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("timeAggregation".equals(fieldName)) {
                    deserializedMetricTrigger.timeAggregation = TimeAggregationType.fromString(reader.getString());
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedMetricTrigger.operator = ComparisonOperationType.fromString(reader.getString());
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedMetricTrigger.threshold = reader.getDouble();
                    continue;
                }
                if ("metricNamespace".equals(fieldName)) {
                    deserializedMetricTrigger.metricNamespace = reader.getString();
                    continue;
                }
                if ("metricResourceLocation".equals(fieldName)) {
                    deserializedMetricTrigger.metricResourceLocation = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List<ScaleRuleMetricDimension> dimensions = reader.readArray(reader1 -> ScaleRuleMetricDimension.fromJson(reader1));
                    deserializedMetricTrigger.dimensions = dimensions;
                    continue;
                }
                if ("dividePerInstance".equals(fieldName)) {
                    deserializedMetricTrigger.dividePerInstance = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricTrigger;
        });
    }
}

