/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ScaleDirection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ScaleType;
import java.io.IOException;
import java.time.Duration;

public final class ScaleAction
implements JsonSerializable<ScaleAction> {
    private ScaleDirection direction;
    private ScaleType type;
    private String value;
    private Duration cooldown;
    private static final ClientLogger LOGGER = new ClientLogger(ScaleAction.class);

    public ScaleDirection direction() {
        return this.direction;
    }

    public ScaleAction withDirection(ScaleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ScaleType type() {
        return this.type;
    }

    public ScaleAction withType(ScaleType type) {
        this.type = type;
        return this;
    }

    public String value() {
        return this.value;
    }

    public ScaleAction withValue(String value) {
        this.value = value;
        return this;
    }

    public Duration cooldown() {
        return this.cooldown;
    }

    public ScaleAction withCooldown(Duration cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public void validate() {
        if (this.direction() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property direction in model ScaleAction"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model ScaleAction"));
        }
        if (this.cooldown() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property cooldown in model ScaleAction"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("cooldown", CoreUtils.durationToStringWithDays(this.cooldown));
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static ScaleAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScaleAction deserializedScaleAction = new ScaleAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("direction".equals(fieldName)) {
                    deserializedScaleAction.direction = ScaleDirection.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScaleAction.type = ScaleType.fromString(reader.getString());
                    continue;
                }
                if ("cooldown".equals(fieldName)) {
                    deserializedScaleAction.cooldown = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedScaleAction.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScaleAction;
        });
    }
}

