/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.WorkspaceInfoProperties;
import java.io.IOException;

public final class WorkspaceInfo
implements JsonSerializable<WorkspaceInfo> {
    private String id;
    private String location;
    private WorkspaceInfoProperties innerProperties = new WorkspaceInfoProperties();
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceInfo.class);

    public String id() {
        return this.id;
    }

    public WorkspaceInfo withId(String id) {
        this.id = id;
        return this;
    }

    public String location() {
        return this.location;
    }

    public WorkspaceInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    private WorkspaceInfoProperties innerProperties() {
        return this.innerProperties;
    }

    public String customerId() {
        return this.innerProperties() == null ? null : this.innerProperties().customerId();
    }

    public WorkspaceInfo withCustomerId(String customerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceInfoProperties();
        }
        this.innerProperties().withCustomerId(customerId);
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model WorkspaceInfo"));
        }
        if (this.location() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property location in model WorkspaceInfo"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model WorkspaceInfo"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceInfo deserializedWorkspaceInfo = new WorkspaceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkspaceInfo.id = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkspaceInfo.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkspaceInfo.innerProperties = WorkspaceInfoProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceInfo;
        });
    }
}

