/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.GatewayLoadBalancerTunnelInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerBackendAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SyncMode;
import java.io.IOException;
import java.util.List;

public final class BackendAddressPoolPropertiesFormat
implements JsonSerializable<BackendAddressPoolPropertiesFormat> {
    private String location;
    private List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces;
    private List<LoadBalancerBackendAddress> loadBalancerBackendAddresses;
    private List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations;
    private List<SubResource> loadBalancingRules;
    private SubResource outboundRule;
    private List<SubResource> outboundRules;
    private List<SubResource> inboundNatRules;
    private ProvisioningState provisioningState;
    private Integer drainPeriodInSeconds;
    private SubResource virtualNetwork;
    private SyncMode syncMode;

    public String location() {
        return this.location;
    }

    public BackendAddressPoolPropertiesFormat withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces() {
        return this.tunnelInterfaces;
    }

    public BackendAddressPoolPropertiesFormat withTunnelInterfaces(List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces) {
        this.tunnelInterfaces = tunnelInterfaces;
        return this;
    }

    public List<LoadBalancerBackendAddress> loadBalancerBackendAddresses() {
        return this.loadBalancerBackendAddresses;
    }

    public BackendAddressPoolPropertiesFormat withLoadBalancerBackendAddresses(List<LoadBalancerBackendAddress> loadBalancerBackendAddresses) {
        this.loadBalancerBackendAddresses = loadBalancerBackendAddresses;
        return this;
    }

    public List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations() {
        return this.backendIpConfigurations;
    }

    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public SubResource outboundRule() {
        return this.outboundRule;
    }

    public List<SubResource> outboundRules() {
        return this.outboundRules;
    }

    public List<SubResource> inboundNatRules() {
        return this.inboundNatRules;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer drainPeriodInSeconds() {
        return this.drainPeriodInSeconds;
    }

    public BackendAddressPoolPropertiesFormat withDrainPeriodInSeconds(Integer drainPeriodInSeconds) {
        this.drainPeriodInSeconds = drainPeriodInSeconds;
        return this;
    }

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public BackendAddressPoolPropertiesFormat withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public SyncMode syncMode() {
        return this.syncMode;
    }

    public BackendAddressPoolPropertiesFormat withSyncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
        return this;
    }

    public void validate() {
        if (this.tunnelInterfaces() != null) {
            this.tunnelInterfaces().forEach(e -> e.validate());
        }
        if (this.loadBalancerBackendAddresses() != null) {
            this.loadBalancerBackendAddresses().forEach(e -> e.validate());
        }
        if (this.backendIpConfigurations() != null) {
            this.backendIpConfigurations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("tunnelInterfaces", this.tunnelInterfaces, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("loadBalancerBackendAddresses", this.loadBalancerBackendAddresses, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("drainPeriodInSeconds", this.drainPeriodInSeconds);
        jsonWriter.writeJsonField("virtualNetwork", this.virtualNetwork);
        jsonWriter.writeStringField("syncMode", this.syncMode == null ? null : this.syncMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static BackendAddressPoolPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendAddressPoolPropertiesFormat deserializedBackendAddressPoolPropertiesFormat = new BackendAddressPoolPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedBackendAddressPoolPropertiesFormat.location = reader.getString();
                    continue;
                }
                if ("tunnelInterfaces".equals(fieldName)) {
                    List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces = reader.readArray(reader1 -> GatewayLoadBalancerTunnelInterface.fromJson(reader1));
                    deserializedBackendAddressPoolPropertiesFormat.tunnelInterfaces = tunnelInterfaces;
                    continue;
                }
                if ("loadBalancerBackendAddresses".equals(fieldName)) {
                    List<LoadBalancerBackendAddress> loadBalancerBackendAddresses = reader.readArray(reader1 -> LoadBalancerBackendAddress.fromJson(reader1));
                    deserializedBackendAddressPoolPropertiesFormat.loadBalancerBackendAddresses = loadBalancerBackendAddresses;
                    continue;
                }
                if ("backendIPConfigurations".equals(fieldName)) {
                    List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations = reader.readArray(reader1 -> NetworkInterfaceIpConfigurationInner.fromJson(reader1));
                    deserializedBackendAddressPoolPropertiesFormat.backendIpConfigurations = backendIpConfigurations;
                    continue;
                }
                if ("loadBalancingRules".equals(fieldName)) {
                    List<SubResource> loadBalancingRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedBackendAddressPoolPropertiesFormat.loadBalancingRules = loadBalancingRules;
                    continue;
                }
                if ("outboundRule".equals(fieldName)) {
                    deserializedBackendAddressPoolPropertiesFormat.outboundRule = SubResource.fromJson(reader);
                    continue;
                }
                if ("outboundRules".equals(fieldName)) {
                    List<SubResource> outboundRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedBackendAddressPoolPropertiesFormat.outboundRules = outboundRules;
                    continue;
                }
                if ("inboundNatRules".equals(fieldName)) {
                    List<SubResource> inboundNatRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedBackendAddressPoolPropertiesFormat.inboundNatRules = inboundNatRules;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBackendAddressPoolPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("drainPeriodInSeconds".equals(fieldName)) {
                    deserializedBackendAddressPoolPropertiesFormat.drainPeriodInSeconds = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedBackendAddressPoolPropertiesFormat.virtualNetwork = SubResource.fromJson(reader);
                    continue;
                }
                if ("syncMode".equals(fieldName)) {
                    deserializedBackendAddressPoolPropertiesFormat.syncMode = SyncMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendAddressPoolPropertiesFormat;
        });
    }
}

