/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;

public final class ExpressRouteConnectionProperties
implements JsonSerializable<ExpressRouteConnectionProperties> {
    private ProvisioningState provisioningState;
    private ExpressRouteCircuitPeeringId expressRouteCircuitPeering;
    private String authorizationKey;
    private Integer routingWeight;
    private Boolean enableInternetSecurity;
    private Boolean expressRouteGatewayBypass;
    private Boolean enablePrivateLinkFastPath;
    private RoutingConfiguration routingConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(ExpressRouteConnectionProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ExpressRouteCircuitPeeringId expressRouteCircuitPeering() {
        return this.expressRouteCircuitPeering;
    }

    public ExpressRouteConnectionProperties withExpressRouteCircuitPeering(ExpressRouteCircuitPeeringId expressRouteCircuitPeering) {
        this.expressRouteCircuitPeering = expressRouteCircuitPeering;
        return this;
    }

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public ExpressRouteConnectionProperties withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public ExpressRouteConnectionProperties withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public ExpressRouteConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.expressRouteGatewayBypass;
    }

    public ExpressRouteConnectionProperties withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        this.expressRouteGatewayBypass = expressRouteGatewayBypass;
        return this;
    }

    public Boolean enablePrivateLinkFastPath() {
        return this.enablePrivateLinkFastPath;
    }

    public ExpressRouteConnectionProperties withEnablePrivateLinkFastPath(Boolean enablePrivateLinkFastPath) {
        this.enablePrivateLinkFastPath = enablePrivateLinkFastPath;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public ExpressRouteConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public void validate() {
        if (this.expressRouteCircuitPeering() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property expressRouteCircuitPeering in model ExpressRouteConnectionProperties"));
        }
        this.expressRouteCircuitPeering().validate();
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("expressRouteCircuitPeering", this.expressRouteCircuitPeering);
        jsonWriter.writeStringField("authorizationKey", this.authorizationKey);
        jsonWriter.writeNumberField("routingWeight", this.routingWeight);
        jsonWriter.writeBooleanField("enableInternetSecurity", this.enableInternetSecurity);
        jsonWriter.writeBooleanField("expressRouteGatewayBypass", this.expressRouteGatewayBypass);
        jsonWriter.writeBooleanField("enablePrivateLinkFastPath", this.enablePrivateLinkFastPath);
        jsonWriter.writeJsonField("routingConfiguration", this.routingConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteConnectionProperties deserializedExpressRouteConnectionProperties = new ExpressRouteConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expressRouteCircuitPeering".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.expressRouteCircuitPeering = ExpressRouteCircuitPeeringId.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("authorizationKey".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.authorizationKey = reader.getString();
                    continue;
                }
                if ("routingWeight".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.routingWeight = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableInternetSecurity".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.enableInternetSecurity = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("expressRouteGatewayBypass".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.expressRouteGatewayBypass = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enablePrivateLinkFastPath".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.enablePrivateLinkFastPath = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("routingConfiguration".equals(fieldName)) {
                    deserializedExpressRouteConnectionProperties.routingConfiguration = RoutingConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteConnectionProperties;
        });
    }
}

