/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ExpressRouteCrossConnectionProperties
implements JsonSerializable<ExpressRouteCrossConnectionProperties> {
    private String primaryAzurePort;
    private String secondaryAzurePort;
    private Integer stag;
    private String peeringLocation;
    private Integer bandwidthInMbps;
    private ExpressRouteCircuitReference expressRouteCircuit;
    private ServiceProviderProvisioningState serviceProviderProvisioningState;
    private String serviceProviderNotes;
    private ProvisioningState provisioningState;
    private List<ExpressRouteCrossConnectionPeeringInner> peerings;

    public String primaryAzurePort() {
        return this.primaryAzurePort;
    }

    public String secondaryAzurePort() {
        return this.secondaryAzurePort;
    }

    public Integer stag() {
        return this.stag;
    }

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public Integer bandwidthInMbps() {
        return this.bandwidthInMbps;
    }

    public ExpressRouteCircuitReference expressRouteCircuit() {
        return this.expressRouteCircuit;
    }

    public ExpressRouteCrossConnectionProperties withExpressRouteCircuit(ExpressRouteCircuitReference expressRouteCircuit) {
        this.expressRouteCircuit = expressRouteCircuit;
        return this;
    }

    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return this.serviceProviderProvisioningState;
    }

    public ExpressRouteCrossConnectionProperties withServiceProviderProvisioningState(ServiceProviderProvisioningState serviceProviderProvisioningState) {
        this.serviceProviderProvisioningState = serviceProviderProvisioningState;
        return this;
    }

    public String serviceProviderNotes() {
        return this.serviceProviderNotes;
    }

    public ExpressRouteCrossConnectionProperties withServiceProviderNotes(String serviceProviderNotes) {
        this.serviceProviderNotes = serviceProviderNotes;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ExpressRouteCrossConnectionPeeringInner> peerings() {
        return this.peerings;
    }

    public ExpressRouteCrossConnectionProperties withPeerings(List<ExpressRouteCrossConnectionPeeringInner> peerings) {
        this.peerings = peerings;
        return this;
    }

    public void validate() {
        if (this.expressRouteCircuit() != null) {
            this.expressRouteCircuit().validate();
        }
        if (this.peerings() != null) {
            this.peerings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("expressRouteCircuit", this.expressRouteCircuit);
        jsonWriter.writeStringField("serviceProviderProvisioningState", this.serviceProviderProvisioningState == null ? null : this.serviceProviderProvisioningState.toString());
        jsonWriter.writeStringField("serviceProviderNotes", this.serviceProviderNotes);
        jsonWriter.writeArrayField("peerings", this.peerings, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCrossConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCrossConnectionProperties deserializedExpressRouteCrossConnectionProperties = new ExpressRouteCrossConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primaryAzurePort".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.primaryAzurePort = reader.getString();
                    continue;
                }
                if ("secondaryAzurePort".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.secondaryAzurePort = reader.getString();
                    continue;
                }
                if ("sTag".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.stag = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.peeringLocation = reader.getString();
                    continue;
                }
                if ("bandwidthInMbps".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.bandwidthInMbps = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("expressRouteCircuit".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.expressRouteCircuit = ExpressRouteCircuitReference.fromJson(reader);
                    continue;
                }
                if ("serviceProviderProvisioningState".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.serviceProviderProvisioningState = ServiceProviderProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("serviceProviderNotes".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.serviceProviderNotes = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("peerings".equals(fieldName)) {
                    List<ExpressRouteCrossConnectionPeeringInner> peerings = reader.readArray(reader1 -> ExpressRouteCrossConnectionPeeringInner.fromJson(reader1));
                    deserializedExpressRouteCrossConnectionProperties.peerings = peerings;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCrossConnectionProperties;
        });
    }
}

