/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualHubId;
import java.io.IOException;
import java.util.List;

public final class ExpressRouteGatewayProperties
implements JsonSerializable<ExpressRouteGatewayProperties> {
    private ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration;
    private List<ExpressRouteConnectionInner> expressRouteConnections;
    private ProvisioningState provisioningState;
    private VirtualHubId virtualHub;
    private Boolean allowNonVirtualWanTraffic;
    private static final ClientLogger LOGGER = new ClientLogger(ExpressRouteGatewayProperties.class);

    public ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration() {
        return this.autoScaleConfiguration;
    }

    public ExpressRouteGatewayProperties withAutoScaleConfiguration(ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration) {
        this.autoScaleConfiguration = autoScaleConfiguration;
        return this;
    }

    public List<ExpressRouteConnectionInner> expressRouteConnections() {
        return this.expressRouteConnections;
    }

    public ExpressRouteGatewayProperties withExpressRouteConnections(List<ExpressRouteConnectionInner> expressRouteConnections) {
        this.expressRouteConnections = expressRouteConnections;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VirtualHubId virtualHub() {
        return this.virtualHub;
    }

    public ExpressRouteGatewayProperties withVirtualHub(VirtualHubId virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public Boolean allowNonVirtualWanTraffic() {
        return this.allowNonVirtualWanTraffic;
    }

    public ExpressRouteGatewayProperties withAllowNonVirtualWanTraffic(Boolean allowNonVirtualWanTraffic) {
        this.allowNonVirtualWanTraffic = allowNonVirtualWanTraffic;
        return this;
    }

    public void validate() {
        if (this.autoScaleConfiguration() != null) {
            this.autoScaleConfiguration().validate();
        }
        if (this.expressRouteConnections() != null) {
            this.expressRouteConnections().forEach(e -> e.validate());
        }
        if (this.virtualHub() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property virtualHub in model ExpressRouteGatewayProperties"));
        }
        this.virtualHub().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualHub", this.virtualHub);
        jsonWriter.writeJsonField("autoScaleConfiguration", this.autoScaleConfiguration);
        jsonWriter.writeArrayField("expressRouteConnections", this.expressRouteConnections, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("allowNonVirtualWanTraffic", this.allowNonVirtualWanTraffic);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteGatewayProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteGatewayProperties deserializedExpressRouteGatewayProperties = new ExpressRouteGatewayProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualHub".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.virtualHub = VirtualHubId.fromJson(reader);
                    continue;
                }
                if ("autoScaleConfiguration".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.autoScaleConfiguration = ExpressRouteGatewayPropertiesAutoScaleConfiguration.fromJson(reader);
                    continue;
                }
                if ("expressRouteConnections".equals(fieldName)) {
                    List<ExpressRouteConnectionInner> expressRouteConnections = reader.readArray(reader1 -> ExpressRouteConnectionInner.fromJson(reader1));
                    deserializedExpressRouteGatewayProperties.expressRouteConnections = expressRouteConnections;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("allowNonVirtualWanTraffic".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.allowNonVirtualWanTraffic = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteGatewayProperties;
        });
    }
}

