/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteLinkInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRoutePortsBillingType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRoutePortsEncapsulation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ExpressRoutePortPropertiesFormat
implements JsonSerializable<ExpressRoutePortPropertiesFormat> {
    private String peeringLocation;
    private Integer bandwidthInGbps;
    private Float provisionedBandwidthInGbps;
    private String mtu;
    private ExpressRoutePortsEncapsulation encapsulation;
    private String etherType;
    private String allocationDate;
    private List<ExpressRouteLinkInner> links;
    private List<SubResource> circuits;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private ExpressRoutePortsBillingType billingType;

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public ExpressRoutePortPropertiesFormat withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    public Integer bandwidthInGbps() {
        return this.bandwidthInGbps;
    }

    public ExpressRoutePortPropertiesFormat withBandwidthInGbps(Integer bandwidthInGbps) {
        this.bandwidthInGbps = bandwidthInGbps;
        return this;
    }

    public Float provisionedBandwidthInGbps() {
        return this.provisionedBandwidthInGbps;
    }

    public String mtu() {
        return this.mtu;
    }

    public ExpressRoutePortsEncapsulation encapsulation() {
        return this.encapsulation;
    }

    public ExpressRoutePortPropertiesFormat withEncapsulation(ExpressRoutePortsEncapsulation encapsulation) {
        this.encapsulation = encapsulation;
        return this;
    }

    public String etherType() {
        return this.etherType;
    }

    public String allocationDate() {
        return this.allocationDate;
    }

    public List<ExpressRouteLinkInner> links() {
        return this.links;
    }

    public ExpressRoutePortPropertiesFormat withLinks(List<ExpressRouteLinkInner> links) {
        this.links = links;
        return this;
    }

    public List<SubResource> circuits() {
        return this.circuits;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ExpressRoutePortsBillingType billingType() {
        return this.billingType;
    }

    public ExpressRoutePortPropertiesFormat withBillingType(ExpressRoutePortsBillingType billingType) {
        this.billingType = billingType;
        return this;
    }

    public void validate() {
        if (this.links() != null) {
            this.links().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeNumberField("bandwidthInGbps", this.bandwidthInGbps);
        jsonWriter.writeStringField("encapsulation", this.encapsulation == null ? null : this.encapsulation.toString());
        jsonWriter.writeArrayField("links", this.links, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("billingType", this.billingType == null ? null : this.billingType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ExpressRoutePortPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRoutePortPropertiesFormat deserializedExpressRoutePortPropertiesFormat = new ExpressRoutePortPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.peeringLocation = reader.getString();
                    continue;
                }
                if ("bandwidthInGbps".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.bandwidthInGbps = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisionedBandwidthInGbps".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.provisionedBandwidthInGbps = reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("mtu".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.mtu = reader.getString();
                    continue;
                }
                if ("encapsulation".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.encapsulation = ExpressRoutePortsEncapsulation.fromString(reader.getString());
                    continue;
                }
                if ("etherType".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.etherType = reader.getString();
                    continue;
                }
                if ("allocationDate".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.allocationDate = reader.getString();
                    continue;
                }
                if ("links".equals(fieldName)) {
                    List<ExpressRouteLinkInner> links = reader.readArray(reader1 -> ExpressRouteLinkInner.fromJson(reader1));
                    deserializedExpressRoutePortPropertiesFormat.links = links;
                    continue;
                }
                if ("circuits".equals(fieldName)) {
                    List<SubResource> circuits = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedExpressRoutePortPropertiesFormat.circuits = circuits;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("billingType".equals(fieldName)) {
                    deserializedExpressRoutePortPropertiesFormat.billingType = ExpressRoutePortsBillingType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRoutePortPropertiesFormat;
        });
    }
}

