/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import java.io.IOException;

public final class FlowLogPropertiesFormat
implements JsonSerializable<FlowLogPropertiesFormat> {
    private String targetResourceId;
    private String targetResourceGuid;
    private String storageId;
    private String enabledFilteringCriteria;
    private Boolean enabled;
    private RetentionPolicyParameters retentionPolicy;
    private FlowLogFormatParameters format;
    private TrafficAnalyticsProperties flowAnalyticsConfiguration;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(FlowLogPropertiesFormat.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public FlowLogPropertiesFormat withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String targetResourceGuid() {
        return this.targetResourceGuid;
    }

    public String storageId() {
        return this.storageId;
    }

    public FlowLogPropertiesFormat withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public String enabledFilteringCriteria() {
        return this.enabledFilteringCriteria;
    }

    public FlowLogPropertiesFormat withEnabledFilteringCriteria(String enabledFilteringCriteria) {
        this.enabledFilteringCriteria = enabledFilteringCriteria;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public FlowLogPropertiesFormat withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.retentionPolicy;
    }

    public FlowLogPropertiesFormat withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.format;
    }

    public FlowLogPropertiesFormat withFormat(FlowLogFormatParameters format) {
        this.format = format;
        return this;
    }

    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.flowAnalyticsConfiguration;
    }

    public FlowLogPropertiesFormat withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        this.flowAnalyticsConfiguration = flowAnalyticsConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property targetResourceId in model FlowLogPropertiesFormat"));
        }
        if (this.storageId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property storageId in model FlowLogPropertiesFormat"));
        }
        if (this.retentionPolicy() != null) {
            this.retentionPolicy().validate();
        }
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.flowAnalyticsConfiguration() != null) {
            this.flowAnalyticsConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("storageId", this.storageId);
        jsonWriter.writeStringField("enabledFilteringCriteria", this.enabledFilteringCriteria);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("retentionPolicy", this.retentionPolicy);
        jsonWriter.writeJsonField("format", this.format);
        jsonWriter.writeJsonField("flowAnalyticsConfiguration", this.flowAnalyticsConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static FlowLogPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowLogPropertiesFormat deserializedFlowLogPropertiesFormat = new FlowLogPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.targetResourceId = reader.getString();
                    continue;
                }
                if ("storageId".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.storageId = reader.getString();
                    continue;
                }
                if ("targetResourceGuid".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.targetResourceGuid = reader.getString();
                    continue;
                }
                if ("enabledFilteringCriteria".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.enabledFilteringCriteria = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.retentionPolicy = RetentionPolicyParameters.fromJson(reader);
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.format = FlowLogFormatParameters.fromJson(reader);
                    continue;
                }
                if ("flowAnalyticsConfiguration".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.flowAnalyticsConfiguration = TrafficAnalyticsProperties.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedFlowLogPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowLogPropertiesFormat;
        });
    }
}

