/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.IpAllocationPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpAllocationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpVersion;
import java.io.IOException;
import java.util.Map;

public final class IpAllocationInner
extends Resource {
    private IpAllocationPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private IpAllocationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public IpAllocationInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IpAllocationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public IpAllocationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public IpAllocationType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public IpAllocationInner withTypePropertiesType(IpAllocationType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public String prefix() {
        return this.innerProperties() == null ? null : this.innerProperties().prefix();
    }

    public IpAllocationInner withPrefix(String prefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withPrefix(prefix);
        return this;
    }

    public Integer prefixLength() {
        return this.innerProperties() == null ? null : this.innerProperties().prefixLength();
    }

    public IpAllocationInner withPrefixLength(Integer prefixLength) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withPrefixLength(prefixLength);
        return this;
    }

    public IpVersion prefixType() {
        return this.innerProperties() == null ? null : this.innerProperties().prefixType();
    }

    public IpAllocationInner withPrefixType(IpVersion prefixType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withPrefixType(prefixType);
        return this;
    }

    public String ipamAllocationId() {
        return this.innerProperties() == null ? null : this.innerProperties().ipamAllocationId();
    }

    public IpAllocationInner withIpamAllocationId(String ipamAllocationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withIpamAllocationId(ipamAllocationId);
        return this;
    }

    public Map<String, String> allocationTags() {
        return this.innerProperties() == null ? null : this.innerProperties().allocationTags();
    }

    public IpAllocationInner withAllocationTags(Map<String, String> allocationTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withAllocationTags(allocationTags);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static IpAllocationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpAllocationInner deserializedIpAllocationInner = new IpAllocationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIpAllocationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIpAllocationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIpAllocationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIpAllocationInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIpAllocationInner.innerProperties = IpAllocationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedIpAllocationInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedIpAllocationInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpAllocationInner;
        });
    }
}

