/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProbeNoHealthyBackendsBehavior;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProbeProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ProbePropertiesFormat
implements JsonSerializable<ProbePropertiesFormat> {
    private List<SubResource> loadBalancingRules;
    private ProbeProtocol protocol;
    private int port;
    private Integer intervalInSeconds;
    private ProbeNoHealthyBackendsBehavior noHealthyBackendsBehavior;
    private Integer numberOfProbes;
    private Integer probeThreshold;
    private String requestPath;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ProbePropertiesFormat.class);

    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public ProbeProtocol protocol() {
        return this.protocol;
    }

    public ProbePropertiesFormat withProtocol(ProbeProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ProbePropertiesFormat withPort(int port) {
        this.port = port;
        return this;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public ProbePropertiesFormat withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    public ProbeNoHealthyBackendsBehavior noHealthyBackendsBehavior() {
        return this.noHealthyBackendsBehavior;
    }

    public ProbePropertiesFormat withNoHealthyBackendsBehavior(ProbeNoHealthyBackendsBehavior noHealthyBackendsBehavior) {
        this.noHealthyBackendsBehavior = noHealthyBackendsBehavior;
        return this;
    }

    public Integer numberOfProbes() {
        return this.numberOfProbes;
    }

    public ProbePropertiesFormat withNumberOfProbes(Integer numberOfProbes) {
        this.numberOfProbes = numberOfProbes;
        return this;
    }

    public Integer probeThreshold() {
        return this.probeThreshold;
    }

    public ProbePropertiesFormat withProbeThreshold(Integer probeThreshold) {
        this.probeThreshold = probeThreshold;
        return this;
    }

    public String requestPath() {
        return this.requestPath;
    }

    public ProbePropertiesFormat withRequestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property protocol in model ProbePropertiesFormat"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeIntField("port", this.port);
        jsonWriter.writeNumberField("intervalInSeconds", this.intervalInSeconds);
        jsonWriter.writeStringField("noHealthyBackendsBehavior", this.noHealthyBackendsBehavior == null ? null : this.noHealthyBackendsBehavior.toString());
        jsonWriter.writeNumberField("numberOfProbes", this.numberOfProbes);
        jsonWriter.writeNumberField("probeThreshold", this.probeThreshold);
        jsonWriter.writeStringField("requestPath", this.requestPath);
        return jsonWriter.writeEndObject();
    }

    public static ProbePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProbePropertiesFormat deserializedProbePropertiesFormat = new ProbePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedProbePropertiesFormat.protocol = ProbeProtocol.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedProbePropertiesFormat.port = reader.getInt();
                    continue;
                }
                if ("loadBalancingRules".equals(fieldName)) {
                    List<SubResource> loadBalancingRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedProbePropertiesFormat.loadBalancingRules = loadBalancingRules;
                    continue;
                }
                if ("intervalInSeconds".equals(fieldName)) {
                    deserializedProbePropertiesFormat.intervalInSeconds = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("noHealthyBackendsBehavior".equals(fieldName)) {
                    deserializedProbePropertiesFormat.noHealthyBackendsBehavior = ProbeNoHealthyBackendsBehavior.fromString(reader.getString());
                    continue;
                }
                if ("numberOfProbes".equals(fieldName)) {
                    deserializedProbePropertiesFormat.numberOfProbes = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("probeThreshold".equals(fieldName)) {
                    deserializedProbePropertiesFormat.probeThreshold = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("requestPath".equals(fieldName)) {
                    deserializedProbePropertiesFormat.requestPath = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedProbePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProbePropertiesFormat;
        });
    }
}

