/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.FlowLogInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressSpace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.DhcpOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PrivateEndpointVNetPolicies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkEncryption;
import java.io.IOException;
import java.util.List;

public final class VirtualNetworkPropertiesFormat
implements JsonSerializable<VirtualNetworkPropertiesFormat> {
    private AddressSpace addressSpace;
    private DhcpOptions dhcpOptions;
    private Integer flowTimeoutInMinutes;
    private List<SubnetInner> subnets;
    private List<VirtualNetworkPeeringInner> virtualNetworkPeerings;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private Boolean enableDdosProtection;
    private Boolean enableVmProtection;
    private SubResource ddosProtectionPlan;
    private VirtualNetworkBgpCommunities bgpCommunities;
    private VirtualNetworkEncryption encryption;
    private List<SubResource> ipAllocations;
    private List<FlowLogInner> flowLogs;
    private PrivateEndpointVNetPolicies privateEndpointVNetPolicies;

    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    public VirtualNetworkPropertiesFormat withAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    public DhcpOptions dhcpOptions() {
        return this.dhcpOptions;
    }

    public VirtualNetworkPropertiesFormat withDhcpOptions(DhcpOptions dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
        return this;
    }

    public Integer flowTimeoutInMinutes() {
        return this.flowTimeoutInMinutes;
    }

    public VirtualNetworkPropertiesFormat withFlowTimeoutInMinutes(Integer flowTimeoutInMinutes) {
        this.flowTimeoutInMinutes = flowTimeoutInMinutes;
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public VirtualNetworkPropertiesFormat withSubnets(List<SubnetInner> subnets) {
        this.subnets = subnets;
        return this;
    }

    public List<VirtualNetworkPeeringInner> virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    public VirtualNetworkPropertiesFormat withVirtualNetworkPeerings(List<VirtualNetworkPeeringInner> virtualNetworkPeerings) {
        this.virtualNetworkPeerings = virtualNetworkPeerings;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean enableDdosProtection() {
        return this.enableDdosProtection;
    }

    public VirtualNetworkPropertiesFormat withEnableDdosProtection(Boolean enableDdosProtection) {
        this.enableDdosProtection = enableDdosProtection;
        return this;
    }

    public Boolean enableVmProtection() {
        return this.enableVmProtection;
    }

    public VirtualNetworkPropertiesFormat withEnableVmProtection(Boolean enableVmProtection) {
        this.enableVmProtection = enableVmProtection;
        return this;
    }

    public SubResource ddosProtectionPlan() {
        return this.ddosProtectionPlan;
    }

    public VirtualNetworkPropertiesFormat withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        this.ddosProtectionPlan = ddosProtectionPlan;
        return this;
    }

    public VirtualNetworkBgpCommunities bgpCommunities() {
        return this.bgpCommunities;
    }

    public VirtualNetworkPropertiesFormat withBgpCommunities(VirtualNetworkBgpCommunities bgpCommunities) {
        this.bgpCommunities = bgpCommunities;
        return this;
    }

    public VirtualNetworkEncryption encryption() {
        return this.encryption;
    }

    public VirtualNetworkPropertiesFormat withEncryption(VirtualNetworkEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<SubResource> ipAllocations() {
        return this.ipAllocations;
    }

    public VirtualNetworkPropertiesFormat withIpAllocations(List<SubResource> ipAllocations) {
        this.ipAllocations = ipAllocations;
        return this;
    }

    public List<FlowLogInner> flowLogs() {
        return this.flowLogs;
    }

    public PrivateEndpointVNetPolicies privateEndpointVNetPolicies() {
        return this.privateEndpointVNetPolicies;
    }

    public VirtualNetworkPropertiesFormat withPrivateEndpointVNetPolicies(PrivateEndpointVNetPolicies privateEndpointVNetPolicies) {
        this.privateEndpointVNetPolicies = privateEndpointVNetPolicies;
        return this;
    }

    public void validate() {
        if (this.addressSpace() != null) {
            this.addressSpace().validate();
        }
        if (this.dhcpOptions() != null) {
            this.dhcpOptions().validate();
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.virtualNetworkPeerings() != null) {
            this.virtualNetworkPeerings().forEach(e -> e.validate());
        }
        if (this.bgpCommunities() != null) {
            this.bgpCommunities().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.flowLogs() != null) {
            this.flowLogs().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("addressSpace", this.addressSpace);
        jsonWriter.writeJsonField("dhcpOptions", this.dhcpOptions);
        jsonWriter.writeNumberField("flowTimeoutInMinutes", this.flowTimeoutInMinutes);
        jsonWriter.writeArrayField("subnets", this.subnets, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("virtualNetworkPeerings", this.virtualNetworkPeerings, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("enableDdosProtection", this.enableDdosProtection);
        jsonWriter.writeBooleanField("enableVmProtection", this.enableVmProtection);
        jsonWriter.writeJsonField("ddosProtectionPlan", this.ddosProtectionPlan);
        jsonWriter.writeJsonField("bgpCommunities", this.bgpCommunities);
        jsonWriter.writeJsonField("encryption", this.encryption);
        jsonWriter.writeArrayField("ipAllocations", this.ipAllocations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("privateEndpointVNetPolicies", this.privateEndpointVNetPolicies == null ? null : this.privateEndpointVNetPolicies.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkPropertiesFormat deserializedVirtualNetworkPropertiesFormat = new VirtualNetworkPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addressSpace".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.addressSpace = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("dhcpOptions".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.dhcpOptions = DhcpOptions.fromJson(reader);
                    continue;
                }
                if ("flowTimeoutInMinutes".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.flowTimeoutInMinutes = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List<SubnetInner> subnets = reader.readArray(reader1 -> SubnetInner.fromJson(reader1));
                    deserializedVirtualNetworkPropertiesFormat.subnets = subnets;
                    continue;
                }
                if ("virtualNetworkPeerings".equals(fieldName)) {
                    List<VirtualNetworkPeeringInner> virtualNetworkPeerings = reader.readArray(reader1 -> VirtualNetworkPeeringInner.fromJson(reader1));
                    deserializedVirtualNetworkPropertiesFormat.virtualNetworkPeerings = virtualNetworkPeerings;
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("enableDdosProtection".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.enableDdosProtection = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableVmProtection".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.enableVmProtection = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ddosProtectionPlan".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.ddosProtectionPlan = SubResource.fromJson(reader);
                    continue;
                }
                if ("bgpCommunities".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.bgpCommunities = VirtualNetworkBgpCommunities.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.encryption = VirtualNetworkEncryption.fromJson(reader);
                    continue;
                }
                if ("ipAllocations".equals(fieldName)) {
                    List<SubResource> ipAllocations = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVirtualNetworkPropertiesFormat.ipAllocations = ipAllocations;
                    continue;
                }
                if ("flowLogs".equals(fieldName)) {
                    List<FlowLogInner> flowLogs = reader.readArray(reader1 -> FlowLogInner.fromJson(reader1));
                    deserializedVirtualNetworkPropertiesFormat.flowLogs = flowLogs;
                    continue;
                }
                if ("privateEndpointVNetPolicies".equals(fieldName)) {
                    deserializedVirtualNetworkPropertiesFormat.privateEndpointVNetPolicies = PrivateEndpointVNetPolicies.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkPropertiesFormat;
        });
    }
}

