/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VpnSiteLinkConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpsecPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VpnConnectionStatus;
import java.io.IOException;
import java.util.List;

public final class VpnConnectionProperties
implements JsonSerializable<VpnConnectionProperties> {
    private SubResource remoteVpnSite;
    private Integer routingWeight;
    private Integer dpdTimeoutSeconds;
    private VpnConnectionStatus connectionStatus;
    private VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType;
    private Long ingressBytesTransferred;
    private Long egressBytesTransferred;
    private Integer connectionBandwidth;
    private String sharedKey;
    private Boolean enableBgp;
    private Boolean usePolicyBasedTrafficSelectors;
    private List<IpsecPolicy> ipsecPolicies;
    private List<TrafficSelectorPolicy> trafficSelectorPolicies;
    private Boolean enableRateLimiting;
    private Boolean enableInternetSecurity;
    private Boolean useLocalAzureIpAddress;
    private ProvisioningState provisioningState;
    private List<VpnSiteLinkConnectionInner> vpnLinkConnections;
    private RoutingConfiguration routingConfiguration;

    public SubResource remoteVpnSite() {
        return this.remoteVpnSite;
    }

    public VpnConnectionProperties withRemoteVpnSite(SubResource remoteVpnSite) {
        this.remoteVpnSite = remoteVpnSite;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public VpnConnectionProperties withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    public VpnConnectionProperties withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        return this;
    }

    public VpnConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType() {
        return this.vpnConnectionProtocolType;
    }

    public VpnConnectionProperties withVpnConnectionProtocolType(VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType) {
        this.vpnConnectionProtocolType = vpnConnectionProtocolType;
        return this;
    }

    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    public Integer connectionBandwidth() {
        return this.connectionBandwidth;
    }

    public VpnConnectionProperties withConnectionBandwidth(Integer connectionBandwidth) {
        this.connectionBandwidth = connectionBandwidth;
        return this;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public VpnConnectionProperties withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VpnConnectionProperties withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.usePolicyBasedTrafficSelectors;
    }

    public VpnConnectionProperties withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        this.usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.ipsecPolicies;
    }

    public VpnConnectionProperties withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        this.ipsecPolicies = ipsecPolicies;
        return this;
    }

    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.trafficSelectorPolicies;
    }

    public VpnConnectionProperties withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        this.trafficSelectorPolicies = trafficSelectorPolicies;
        return this;
    }

    public Boolean enableRateLimiting() {
        return this.enableRateLimiting;
    }

    public VpnConnectionProperties withEnableRateLimiting(Boolean enableRateLimiting) {
        this.enableRateLimiting = enableRateLimiting;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public VpnConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public Boolean useLocalAzureIpAddress() {
        return this.useLocalAzureIpAddress;
    }

    public VpnConnectionProperties withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        this.useLocalAzureIpAddress = useLocalAzureIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<VpnSiteLinkConnectionInner> vpnLinkConnections() {
        return this.vpnLinkConnections;
    }

    public VpnConnectionProperties withVpnLinkConnections(List<VpnSiteLinkConnectionInner> vpnLinkConnections) {
        this.vpnLinkConnections = vpnLinkConnections;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public VpnConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public void validate() {
        if (this.ipsecPolicies() != null) {
            this.ipsecPolicies().forEach(e -> e.validate());
        }
        if (this.trafficSelectorPolicies() != null) {
            this.trafficSelectorPolicies().forEach(e -> e.validate());
        }
        if (this.vpnLinkConnections() != null) {
            this.vpnLinkConnections().forEach(e -> e.validate());
        }
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("remoteVpnSite", this.remoteVpnSite);
        jsonWriter.writeNumberField("routingWeight", this.routingWeight);
        jsonWriter.writeNumberField("dpdTimeoutSeconds", this.dpdTimeoutSeconds);
        jsonWriter.writeStringField("vpnConnectionProtocolType", this.vpnConnectionProtocolType == null ? null : this.vpnConnectionProtocolType.toString());
        jsonWriter.writeNumberField("connectionBandwidth", this.connectionBandwidth);
        jsonWriter.writeStringField("sharedKey", this.sharedKey);
        jsonWriter.writeBooleanField("enableBgp", this.enableBgp);
        jsonWriter.writeBooleanField("usePolicyBasedTrafficSelectors", this.usePolicyBasedTrafficSelectors);
        jsonWriter.writeArrayField("ipsecPolicies", this.ipsecPolicies, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("trafficSelectorPolicies", this.trafficSelectorPolicies, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("enableRateLimiting", this.enableRateLimiting);
        jsonWriter.writeBooleanField("enableInternetSecurity", this.enableInternetSecurity);
        jsonWriter.writeBooleanField("useLocalAzureIpAddress", this.useLocalAzureIpAddress);
        jsonWriter.writeArrayField("vpnLinkConnections", this.vpnLinkConnections, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("routingConfiguration", this.routingConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static VpnConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnConnectionProperties deserializedVpnConnectionProperties = new VpnConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("remoteVpnSite".equals(fieldName)) {
                    deserializedVpnConnectionProperties.remoteVpnSite = SubResource.fromJson(reader);
                    continue;
                }
                if ("routingWeight".equals(fieldName)) {
                    deserializedVpnConnectionProperties.routingWeight = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dpdTimeoutSeconds".equals(fieldName)) {
                    deserializedVpnConnectionProperties.dpdTimeoutSeconds = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("connectionStatus".equals(fieldName)) {
                    deserializedVpnConnectionProperties.connectionStatus = VpnConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("vpnConnectionProtocolType".equals(fieldName)) {
                    deserializedVpnConnectionProperties.vpnConnectionProtocolType = VirtualNetworkGatewayConnectionProtocol.fromString(reader.getString());
                    continue;
                }
                if ("ingressBytesTransferred".equals(fieldName)) {
                    deserializedVpnConnectionProperties.ingressBytesTransferred = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("egressBytesTransferred".equals(fieldName)) {
                    deserializedVpnConnectionProperties.egressBytesTransferred = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("connectionBandwidth".equals(fieldName)) {
                    deserializedVpnConnectionProperties.connectionBandwidth = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sharedKey".equals(fieldName)) {
                    deserializedVpnConnectionProperties.sharedKey = reader.getString();
                    continue;
                }
                if ("enableBgp".equals(fieldName)) {
                    deserializedVpnConnectionProperties.enableBgp = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("usePolicyBasedTrafficSelectors".equals(fieldName)) {
                    deserializedVpnConnectionProperties.usePolicyBasedTrafficSelectors = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ipsecPolicies".equals(fieldName)) {
                    List<IpsecPolicy> ipsecPolicies = reader.readArray(reader1 -> IpsecPolicy.fromJson(reader1));
                    deserializedVpnConnectionProperties.ipsecPolicies = ipsecPolicies;
                    continue;
                }
                if ("trafficSelectorPolicies".equals(fieldName)) {
                    List<TrafficSelectorPolicy> trafficSelectorPolicies = reader.readArray(reader1 -> TrafficSelectorPolicy.fromJson(reader1));
                    deserializedVpnConnectionProperties.trafficSelectorPolicies = trafficSelectorPolicies;
                    continue;
                }
                if ("enableRateLimiting".equals(fieldName)) {
                    deserializedVpnConnectionProperties.enableRateLimiting = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableInternetSecurity".equals(fieldName)) {
                    deserializedVpnConnectionProperties.enableInternetSecurity = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("useLocalAzureIpAddress".equals(fieldName)) {
                    deserializedVpnConnectionProperties.useLocalAzureIpAddress = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVpnConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("vpnLinkConnections".equals(fieldName)) {
                    List<VpnSiteLinkConnectionInner> vpnLinkConnections = reader.readArray(reader1 -> VpnSiteLinkConnectionInner.fromJson(reader1));
                    deserializedVpnConnectionProperties.vpnLinkConnections = vpnLinkConnections;
                    continue;
                }
                if ("routingConfiguration".equals(fieldName)) {
                    deserializedVpnConnectionProperties.routingConfiguration = RoutingConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnConnectionProperties;
        });
    }
}

