/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.ApplicationGatewaysClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewaySkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateways;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.exception.AggregatedManagementException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ApplicationGatewaysImpl
extends TopLevelModifiableResourcesImpl<ApplicationGateway, ApplicationGatewayImpl, ApplicationGatewayInner, ApplicationGatewaysClient, NetworkManager>
implements ApplicationGateways {
    public ApplicationGatewaysImpl(NetworkManager networkManager) {
        super(((NetworkManagementClient)networkManager.serviceClient()).getApplicationGateways(), networkManager);
    }

    @Override
    public ApplicationGatewayImpl define(String name) {
        return this.wrapModel(name).withSize(ApplicationGatewaySkuName.BASIC).withTier(ApplicationGatewayTier.BASIC).withInstanceCount(1);
    }

    @Override
    protected ApplicationGatewayImpl wrapModel(String name) {
        ApplicationGatewayInner inner = new ApplicationGatewayInner();
        return new ApplicationGatewayImpl(name, inner, (NetworkManager)this.manager());
    }

    @Override
    protected ApplicationGatewayImpl wrapModel(ApplicationGatewayInner inner) {
        return inner == null ? null : new ApplicationGatewayImpl(inner.name(), inner, (NetworkManager)this.manager());
    }

    @Override
    public void start(String ... applicationGatewayResourceId) {
        if (applicationGatewayResourceId == null) {
            return;
        }
        this.startAsync(applicationGatewayResourceId).blockLast();
    }

    @Override
    public Flux<String> startAsync(String ... applicationGatewayResourceId) {
        return this.startAsync(new ArrayList<String>(Arrays.asList(applicationGatewayResourceId)));
    }

    @Override
    public void stop(String ... applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return;
        }
        this.stopAsync(applicationGatewayResourceIds).blockLast();
    }

    @Override
    public void start(Collection<String> applicationGatewayResourceIds) {
        this.startAsync(applicationGatewayResourceIds).blockLast();
    }

    @Override
    public void stop(Collection<String> applicationGatewayResourceIds) {
        this.stopAsync(applicationGatewayResourceIds).blockLast();
    }

    @Override
    public Flux<String> stopAsync(String ... applicationGatewayResourceIds) {
        return this.stopAsync(new ArrayList<String>(Arrays.asList(applicationGatewayResourceIds)));
    }

    @Override
    public Flux<String> startAsync(Collection<String> applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return Flux.empty();
        }
        return Flux.fromIterable(applicationGatewayResourceIds).flatMapDelayError(id -> {
            String resourceGroupName = ResourceUtils.groupFromResourceId(id);
            String name = ResourceUtils.nameFromResourceId(id);
            return ((ApplicationGatewaysClient)this.inner()).startAsync(resourceGroupName, name).then(Mono.just(id));
        }, 32, 32).onErrorMap(AggregatedManagementException::convertToManagementException).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }

    @Override
    public Flux<String> stopAsync(Collection<String> applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return Flux.empty();
        }
        return Flux.fromIterable(applicationGatewayResourceIds).flatMapDelayError(id -> {
            String resourceGroupName = ResourceUtils.groupFromResourceId(id);
            String name = ResourceUtils.nameFromResourceId(id);
            return ((ApplicationGatewaysClient)this.inner()).stopAsync(resourceGroupName, name).then(Mono.just(id));
        }, 32, 32).onErrorMap(AggregatedManagementException::convertToManagementException).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }
}

