/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkPeering;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkPeeringGatewayUse;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkPeeringState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.List;

class NetworkPeeringImpl
extends IndependentChildImpl<NetworkPeering, Network, VirtualNetworkPeeringInner, NetworkPeeringImpl, NetworkManager>
implements NetworkPeering,
NetworkPeering.Definition,
NetworkPeering.Update {
    private NetworkImpl parent;
    private Network remoteNetwork;
    private Boolean remoteAccess;
    private Boolean remoteForwarding;
    private Boolean startGatewayUseByRemoteNetwork;
    private Boolean allowGatewayUseOnRemoteNetwork;

    NetworkPeeringImpl(VirtualNetworkPeeringInner inner, NetworkImpl parent) {
        super(inner.name(), inner, (NetworkManager)parent.manager());
        this.parent = parent;
        this.remoteAccess = null;
        this.remoteForwarding = null;
    }

    @Override
    public boolean isSameSubscription() {
        if (this.remoteNetworkId() == null) {
            return false;
        }
        String localSubscriptionId = ResourceUtils.subscriptionFromResourceId(this.id());
        String remoteSubscriptionId = ResourceUtils.subscriptionFromResourceId(this.remoteNetworkId());
        return localSubscriptionId.equalsIgnoreCase(remoteSubscriptionId);
    }

    @Override
    public VirtualNetworkPeeringState state() {
        return ((VirtualNetworkPeeringInner)this.innerModel()).peeringState();
    }

    @Override
    public String name() {
        return ((VirtualNetworkPeeringInner)this.innerModel()).name();
    }

    @Override
    public String id() {
        return ((VirtualNetworkPeeringInner)this.innerModel()).id();
    }

    @Override
    public String networkId() {
        return this.parent.id();
    }

    @Override
    public List<String> remoteAddressSpaces() {
        if (((VirtualNetworkPeeringInner)this.innerModel()).remoteAddressSpace() == null || ((VirtualNetworkPeeringInner)this.innerModel()).remoteAddressSpace().addressPrefixes() == null) {
            return null;
        }
        return Collections.unmodifiableList(((VirtualNetworkPeeringInner)this.innerModel()).remoteAddressSpace().addressPrefixes());
    }

    @Override
    public String remoteNetworkId() {
        return ((VirtualNetworkPeeringInner)this.innerModel()).remoteVirtualNetwork() != null ? ((VirtualNetworkPeeringInner)this.innerModel()).remoteVirtualNetwork().id() : null;
    }

    @Override
    public boolean isTrafficForwardingFromRemoteNetworkAllowed() {
        return ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkPeeringInner)this.innerModel()).allowForwardedTraffic());
    }

    private boolean isAccessFromRemoteNetworkAllowed() {
        return ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkPeeringInner)this.innerModel()).allowVirtualNetworkAccess());
    }

    private NetworkPeeringImpl withoutAccessFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withAllowVirtualNetworkAccess(false);
        return this;
    }

    private NetworkPeeringImpl withAccessFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withAllowVirtualNetworkAccess(true);
        return this;
    }

    @Override
    public NetworkPeeringImpl withAccessBetweenBothNetworks() {
        return this.withAccessFromRemoteNetwork().withAccessToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withoutAccessFromEitherNetwork() {
        return this.withoutAccessFromRemoteNetwork().withoutAccessToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withRemoteNetwork(String resourceId) {
        SubResource networkRef = new SubResource().withId(resourceId);
        ((VirtualNetworkPeeringInner)this.innerModel()).withRemoteVirtualNetwork(networkRef);
        return this;
    }

    @Override
    public NetworkPeeringImpl withRemoteNetwork(Network network) {
        if (network != null) {
            this.remoteNetwork = network;
            return this.withRemoteNetwork(network.id());
        }
        return this;
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withAllowForwardedTraffic(true);
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withAllowForwardedTraffic(false);
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingFromEitherNetwork() {
        return this.withoutTrafficForwardingFromRemoteNetwork().withoutTrafficForwardingToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingToRemoteNetwork() {
        this.remoteForwarding = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingToRemoteNetwork() {
        this.remoteForwarding = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingBetweenBothNetworks() {
        return this.withTrafficForwardingFromRemoteNetwork().withTrafficForwardingToRemoteNetwork();
    }

    private NetworkPeeringImpl withoutAccessToRemoteNetwork() {
        this.remoteAccess = false;
        return this;
    }

    private NetworkPeeringImpl withAccessToRemoteNetwork() {
        this.remoteAccess = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withGatewayUseByRemoteNetworkAllowed() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withAllowGatewayTransit(true).withUseRemoteGateways(false);
        this.startGatewayUseByRemoteNetwork = null;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withGatewayUseByRemoteNetworkStarted() {
        this.startGatewayUseByRemoteNetwork = true;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this.withGatewayUseByRemoteNetworkAllowed();
    }

    @Override
    public NetworkPeeringImpl withGatewayUseOnRemoteNetworkStarted() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withAllowGatewayTransit(false).withUseRemoteGateways(true);
        this.startGatewayUseByRemoteNetwork = false;
        this.allowGatewayUseOnRemoteNetwork = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutAnyGatewayUse() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withAllowGatewayTransit(false);
        return this.withoutGatewayUseOnRemoteNetwork().withoutGatewayUseByRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withoutGatewayUseByRemoteNetwork() {
        this.startGatewayUseByRemoteNetwork = false;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutGatewayUseOnRemoteNetwork() {
        ((VirtualNetworkPeeringInner)this.innerModel()).withUseRemoteGateways(false);
        return this;
    }

    @Override
    public boolean checkAccessBetweenNetworks() {
        if (!ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkPeeringInner)this.innerModel()).allowVirtualNetworkAccess())) {
            return false;
        }
        NetworkPeering remotePeering = this.getRemotePeering();
        if (remotePeering == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkPeeringInner)remotePeering.innerModel()).allowVirtualNetworkAccess());
    }

    @Override
    protected Mono<NetworkPeering> createChildResourceAsync() {
        NetworkPeeringImpl localPeering = this;
        String networkName = ResourceUtils.nameFromResourceId(this.networkId());
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkPeerings().createOrUpdateAsync(this.parent.resourceGroupName(), networkName, this.name(), (VirtualNetworkPeeringInner)this.innerModel()).doOnNext(inner -> this.setInner(inner)).flatMap(inner -> {
            SubResource networkRef = inner.remoteVirtualNetwork();
            if (localPeering.isSameSubscription()) {
                return ((NetworkManager)localPeering.manager()).networks().getByIdAsync(networkRef.id());
            }
            return Mono.empty();
        }).flatMap(remoteNetwork -> remoteNetwork.peerings().listAsync().filter(remotePeering -> remotePeering != null && remotePeering.remoteNetworkId() != null && remotePeering.remoteNetworkId().equalsIgnoreCase(localPeering.parent.id())).collectList().flatMap(remotePeerings -> {
            if (remotePeerings.isEmpty()) {
                return Mono.empty();
            }
            return Mono.justOrEmpty((NetworkPeering)remotePeerings.get(remotePeerings.size() - 1));
        }).flatMap(remotePeering -> {
            NetworkPeering.Update remotePeeringUpdate = (NetworkPeering.Update)remotePeering.update();
            boolean isUpdateNeeded = false;
            if (localPeering.remoteForwarding != null) {
                if (localPeering.remoteForwarding.booleanValue() && !remotePeering.isTrafficForwardingFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = remotePeeringUpdate.withTrafficForwardingFromRemoteNetwork();
                } else if (!localPeering.remoteForwarding.booleanValue() && remotePeering.isTrafficForwardingFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = remotePeeringUpdate.withoutTrafficForwardingFromRemoteNetwork();
                }
            }
            if (localPeering.remoteAccess != null) {
                if (localPeering.remoteAccess.booleanValue() && !((NetworkPeeringImpl)remotePeering).isAccessFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = ((NetworkPeeringImpl)remotePeeringUpdate).withAccessFromRemoteNetwork();
                } else if (!localPeering.remoteAccess.booleanValue() && ((NetworkPeeringImpl)remotePeering).isAccessFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = ((NetworkPeeringImpl)remotePeeringUpdate).withoutAccessFromRemoteNetwork();
                }
            }
            if (localPeering.allowGatewayUseOnRemoteNetwork != null) {
                if (localPeering.allowGatewayUseOnRemoteNetwork.booleanValue() && remotePeering.gatewayUse() != NetworkPeeringGatewayUse.BY_REMOTE_NETWORK) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate.withGatewayUseByRemoteNetworkAllowed();
                } else if (!localPeering.allowGatewayUseOnRemoteNetwork.booleanValue() && remotePeering.gatewayUse() == NetworkPeeringGatewayUse.BY_REMOTE_NETWORK) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate.withoutGatewayUseByRemoteNetwork();
                }
            }
            if (localPeering.startGatewayUseByRemoteNetwork != null) {
                if (localPeering.startGatewayUseByRemoteNetwork.booleanValue() && remotePeering.gatewayUse() != NetworkPeeringGatewayUse.ON_REMOTE_NETWORK) {
                    remotePeeringUpdate.withGatewayUseOnRemoteNetworkStarted();
                    isUpdateNeeded = true;
                } else if (!localPeering.startGatewayUseByRemoteNetwork.booleanValue() && remotePeering.gatewayUse() == NetworkPeeringGatewayUse.ON_REMOTE_NETWORK) {
                    remotePeeringUpdate.withoutGatewayUseOnRemoteNetwork();
                    isUpdateNeeded = true;
                }
            }
            if (isUpdateNeeded) {
                localPeering.remoteForwarding = null;
                localPeering.remoteAccess = null;
                localPeering.startGatewayUseByRemoteNetwork = null;
                localPeering.allowGatewayUseOnRemoteNetwork = null;
                return remotePeeringUpdate.applyAsync();
            }
            return Mono.just(localPeering);
        }).switchIfEmpty(Mono.defer(() -> {
            String peeringName = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("peer", 15);
            NetworkPeering.DefinitionStages.WithCreate remotePeeringDefinition = ((NetworkPeering.DefinitionStages.Blank)remoteNetwork.peerings().define(peeringName)).withRemoteNetwork(localPeering.parent.id());
            if (localPeering.startGatewayUseByRemoteNetwork != null && localPeering.startGatewayUseByRemoteNetwork.booleanValue()) {
                remotePeeringDefinition.withGatewayUseOnRemoteNetworkStarted();
            }
            if (localPeering.allowGatewayUseOnRemoteNetwork != null && localPeering.allowGatewayUseOnRemoteNetwork.booleanValue()) {
                remotePeeringDefinition.withGatewayUseByRemoteNetworkAllowed();
            }
            if (localPeering.remoteAccess != null && !localPeering.remoteAccess.booleanValue()) {
                ((NetworkPeeringImpl)remotePeeringDefinition).withoutAccessFromRemoteNetwork();
            }
            if (localPeering.remoteForwarding != null && localPeering.remoteForwarding.booleanValue()) {
                remotePeeringDefinition.withTrafficForwardingFromRemoteNetwork();
            }
            localPeering.remoteAccess = null;
            localPeering.remoteForwarding = null;
            localPeering.startGatewayUseByRemoteNetwork = null;
            localPeering.allowGatewayUseOnRemoteNetwork = null;
            return remotePeeringDefinition.createAsync();
        }))).flatMap(remotePeering -> localPeering.parent != null ? localPeering.parent.refreshAsync() : Mono.empty()).flatMap(t -> {
            if (localPeering.remoteNetwork != null && localPeering.isSameSubscription()) {
                return localPeering.remoteNetwork.refreshAsync();
            }
            return Mono.empty();
        }).then(Mono.just(localPeering));
    }

    @Override
    protected Mono<VirtualNetworkPeeringInner> getInnerAsync() {
        this.remoteNetwork = null;
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkPeerings().getAsync(this.resourceGroupName(), ResourceUtils.nameFromResourceId(this.networkId()), ((VirtualNetworkPeeringInner)this.innerModel()).name());
    }

    @Override
    public Network getRemoteNetwork() {
        return this.getRemoteNetworkAsync().block();
    }

    @Override
    public Mono<Network> getRemoteNetworkAsync() {
        NetworkPeeringImpl self = this;
        if (self.remoteNetwork != null) {
            return Mono.just(self.remoteNetwork);
        }
        if (this.isSameSubscription()) {
            return ((NetworkManager)this.manager()).networks().getByIdAsync(this.remoteNetworkId()).doOnNext(network -> {
                self.remoteNetwork = network;
            });
        }
        self.remoteNetwork = null;
        return Mono.empty();
    }

    @Override
    public NetworkPeering getRemotePeering() {
        Network network = this.getRemoteNetwork();
        return network != null ? network.peerings().getByRemoteNetwork(this.networkId()) : null;
    }

    @Override
    public Mono<NetworkPeering> getRemotePeeringAsync() {
        NetworkPeeringImpl self = this;
        return this.getRemoteNetworkAsync().flatMap(remoteNetwork -> {
            if (remoteNetwork == null) {
                return Mono.empty();
            }
            return remoteNetwork.peerings().getByRemoteNetworkAsync(self.networkId());
        });
    }

    @Override
    public NetworkPeeringGatewayUse gatewayUse() {
        if (ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkPeeringInner)this.innerModel()).allowGatewayTransit())) {
            return NetworkPeeringGatewayUse.BY_REMOTE_NETWORK;
        }
        if (ResourceManagerUtils.toPrimitiveBoolean(((VirtualNetworkPeeringInner)this.innerModel()).useRemoteGateways())) {
            return NetworkPeeringGatewayUse.ON_REMOTE_NETWORK;
        }
        return NetworkPeeringGatewayUse.NONE;
    }
}

