/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.RouteFilterInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.RouteFilterRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ExpressRouteCircuitPeeringImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.RouteFilterRuleImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Access;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitPeering;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteFilter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteFilterRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteFilterRuleType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

class RouteFilterImpl
extends GroupableParentResourceImpl<RouteFilter, RouteFilterInner, RouteFilterImpl, NetworkManager>
implements RouteFilter,
RouteFilter.Definition,
RouteFilter.Update {
    private static final String RULE_TYPE = "Community";
    private Map<String, RouteFilterRule> rules;
    private Map<String, ExpressRouteCircuitPeering> peerings;

    RouteFilterImpl(String name, RouteFilterInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    protected Mono<RouteFilterInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getRouteFilters().createOrUpdateAsync(this.resourceGroupName(), this.name(), (RouteFilterInner)this.innerModel());
    }

    @Override
    protected void initializeChildrenFromInner() {
        this.rules = new TreeMap<String, RouteFilterRule>();
        List<RouteFilterRuleInner> inners = ((RouteFilterInner)this.innerModel()).rules();
        if (inners != null) {
            for (RouteFilterRuleInner inner : inners) {
                this.rules.put(inner.name(), new RouteFilterRuleImpl(inner, this));
            }
        }
        this.peerings = ((RouteFilterInner)this.innerModel()).peerings() != null ? ((RouteFilterInner)this.innerModel()).peerings().stream().collect(Collectors.toMap(ExpressRouteCircuitPeeringInner::name, peering -> new ExpressRouteCircuitPeeringImpl(this, (ExpressRouteCircuitPeeringInner)peering, ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuitPeerings(), peering.peeringType()))) : new HashMap<String, ExpressRouteCircuitPeering>();
    }

    @Override
    protected void beforeCreating() {
        ((RouteFilterInner)this.innerModel()).withRules(this.innersFromWrappers(this.rules.values()));
    }

    @Override
    protected Mono<RouteFilterInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getRouteFilters().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<RouteFilter> refreshAsync() {
        return super.refreshAsync().map(routeFilter -> {
            RouteFilterImpl impl = (RouteFilterImpl)routeFilter;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    @Override
    public String provisioningState() {
        return ((RouteFilterInner)this.innerModel()).provisioningState().toString();
    }

    @Override
    public Map<String, RouteFilterRule> rules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public Map<String, ExpressRouteCircuitPeering> peerings() {
        return Collections.unmodifiableMap(this.peerings);
    }

    RouteFilterImpl withRule(RouteFilterRuleImpl rule) {
        this.rules.put(rule.name(), rule);
        return this;
    }

    @Override
    public RouteFilter.Update withoutRule(String name) {
        this.rules.remove(name);
        return this;
    }

    public RouteFilterRuleImpl defineRule(String name) {
        RouteFilterRuleInner inner = new RouteFilterRuleInner();
        inner.withName(name);
        inner.withRouteFilterRuleType(RouteFilterRuleType.COMMUNITY);
        inner.withAccess(Access.ALLOW);
        return new RouteFilterRuleImpl(inner, this);
    }

    @Override
    public RouteFilterRule.Update updateRule(String name) {
        return (RouteFilterRuleImpl)this.rules.get(name);
    }
}

