/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.IpAddressAvailabilityResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Delegation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteTable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ServiceEndpointPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ServiceEndpointType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Subnet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkPrivateEndpointNetworkPolicies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkPrivateLinkServiceNetworkPolicies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class SubnetImpl
extends ChildResourceImpl<SubnetInner, NetworkImpl, Network>
implements Subnet,
Subnet.Definition<Network.DefinitionStages.WithCreateAndSubnet>,
Subnet.UpdateDefinition<Network.Update>,
Subnet.Update {
    private static final ClientLogger LOGGER = new ClientLogger(SubnetImpl.class);

    SubnetImpl(SubnetInner inner, NetworkImpl parent) {
        super(inner, parent);
    }

    @Override
    public int networkInterfaceIPConfigurationCount() {
        List<IpConfigurationInner> ipConfigRefs = ((SubnetInner)this.innerModel()).ipConfigurations();
        if (ipConfigRefs != null) {
            return ipConfigRefs.size();
        }
        return 0;
    }

    @Override
    public String addressPrefix() {
        return ((SubnetInner)this.innerModel()).addressPrefix();
    }

    @Override
    public List<String> addressPrefixes() {
        if (CoreUtils.isNullOrEmpty(((SubnetInner)this.innerModel()).addressPrefixes())) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((SubnetInner)this.innerModel()).addressPrefixes());
    }

    @Override
    public String name() {
        return ((SubnetInner)this.innerModel()).name();
    }

    @Override
    public String networkSecurityGroupId() {
        return ((SubnetInner)this.innerModel()).networkSecurityGroup() != null ? ((SubnetInner)this.innerModel()).networkSecurityGroup().id() : null;
    }

    @Override
    public String routeTableId() {
        return ((SubnetInner)this.innerModel()).routeTable() != null ? ((SubnetInner)this.innerModel()).routeTable().id() : null;
    }

    @Override
    public Map<ServiceEndpointType, List<Region>> servicesWithAccess() {
        HashMap<ServiceEndpointType, List<Region>> services = new HashMap<ServiceEndpointType, List<Region>>();
        if (((SubnetInner)this.innerModel()).serviceEndpoints() != null) {
            for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)this.innerModel()).serviceEndpoints()) {
                ServiceEndpointType serviceEndpointType = ServiceEndpointType.fromString(endpoint.service());
                if (!services.containsKey(serviceEndpointType)) {
                    services.put(serviceEndpointType, new ArrayList());
                }
                if (endpoint.locations() == null) continue;
                ArrayList<Region> regions = new ArrayList<Region>();
                for (String location : endpoint.locations()) {
                    regions.add(Region.fromName(location));
                }
                ((List)services.get(serviceEndpointType)).addAll(regions);
            }
        }
        return services;
    }

    @Override
    public String id() {
        return ((SubnetInner)this.innerModel()).id();
    }

    @Override
    public String natGatewayId() {
        SubResource natGateway = ((SubnetInner)this.innerModel()).natGateway();
        if (natGateway == null) {
            return null;
        }
        return natGateway.id();
    }

    @Override
    public SubnetImpl withoutNetworkSecurityGroup() {
        ((SubnetInner)this.innerModel()).withNetworkSecurityGroup(null);
        return this;
    }

    @Override
    public SubnetImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup nsg) {
        return this.withExistingNetworkSecurityGroup(nsg.id());
    }

    @Override
    public SubnetImpl withExistingNetworkSecurityGroup(String resourceId) {
        NetworkSecurityGroupInner reference = new NetworkSecurityGroupInner().withId(resourceId);
        ((SubnetInner)this.innerModel()).withNetworkSecurityGroup(reference);
        return this;
    }

    @Override
    public SubnetImpl withExistingRouteTable(String resourceId) {
        RouteTableInner reference = new RouteTableInner().withId(resourceId);
        ((SubnetInner)this.innerModel()).withRouteTable(reference);
        return this;
    }

    @Override
    public SubnetImpl withExistingRouteTable(RouteTable routeTable) {
        return this.withExistingRouteTable(routeTable.id());
    }

    @Override
    public Subnet.Update withoutRouteTable() {
        ((SubnetInner)this.innerModel()).withRouteTable(null);
        return this;
    }

    @Override
    public SubnetImpl withAddressPrefix(String cidr) {
        ((SubnetInner)this.innerModel()).withAddressPrefix(cidr);
        ((SubnetInner)this.innerModel()).withAddressPrefixes(null);
        return this;
    }

    @Override
    public SubnetImpl withAddressPrefixes(Collection<String> addressPrefixes) {
        Objects.requireNonNull(addressPrefixes);
        ((SubnetInner)this.innerModel()).withAddressPrefixes(new ArrayList<String>(addressPrefixes));
        ((SubnetInner)this.innerModel()).withAddressPrefix(null);
        return this;
    }

    @Override
    public SubnetImpl withAccessFromService(ServiceEndpointType service) {
        if (((SubnetInner)this.innerModel()).serviceEndpoints() == null) {
            ((SubnetInner)this.innerModel()).withServiceEndpoints(new ArrayList<ServiceEndpointPropertiesFormat>());
        }
        boolean found = false;
        for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)this.innerModel()).serviceEndpoints()) {
            if (!endpoint.service().equalsIgnoreCase(service.toString())) continue;
            found = true;
            break;
        }
        if (!found) {
            ((SubnetInner)this.innerModel()).serviceEndpoints().add(new ServiceEndpointPropertiesFormat().withService(service.toString()).withLocations(new ArrayList<String>()));
        }
        return this;
    }

    @Override
    public Subnet.Update withoutAccessFromService(ServiceEndpointType service) {
        if (((SubnetInner)this.innerModel()).serviceEndpoints() != null) {
            int foundIndex = -1;
            int i = 0;
            for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)this.innerModel()).serviceEndpoints()) {
                if (endpoint.service().equalsIgnoreCase(service.toString())) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex != -1) {
                ((SubnetInner)this.innerModel()).serviceEndpoints().remove(foundIndex);
            }
        }
        return this;
    }

    @Override
    public NetworkImpl attach() {
        return ((NetworkImpl)this.parent()).withSubnet(this);
    }

    @Override
    public RouteTable getRouteTable() {
        return this.routeTableId() != null ? (RouteTable)((NetworkManager)((NetworkImpl)this.parent()).manager()).routeTables().getById(this.routeTableId()) : null;
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        String nsgId = this.networkSecurityGroupId();
        return nsgId != null ? (NetworkSecurityGroup)((NetworkManager)((NetworkImpl)this.parent()).manager()).networkSecurityGroups().getById(nsgId) : null;
    }

    @Override
    public Collection<NicIpConfiguration> listNetworkInterfaceIPConfigurations() {
        ArrayList<NicIpConfiguration> ipConfigs = new ArrayList<NicIpConfiguration>();
        TreeMap<String, NetworkInterface> nics = new TreeMap<String, NetworkInterface>(Comparator.comparing(key -> key.toLowerCase(Locale.ROOT)));
        List<IpConfigurationInner> ipConfigRefs = ((SubnetInner)this.innerModel()).ipConfigurations();
        if (ipConfigRefs == null) {
            return ipConfigs;
        }
        for (IpConfigurationInner ipConfigRef : ipConfigRefs) {
            String resourceType;
            String nicID = ResourceUtils.parentResourceIdFromResourceId(ipConfigRef.id());
            String ipConfigName = ResourceUtils.nameFromResourceId(ipConfigRef.id());
            NetworkInterface nic = (NetworkInterface)nics.get(nicID);
            if (nic == null && "networkInterfaces".equalsIgnoreCase(resourceType = ResourceUtils.resourceTypeFromResourceId(nicID))) {
                try {
                    nic = (NetworkInterface)((NetworkManager)((NetworkImpl)this.parent()).manager()).networkInterfaces().getById(nicID);
                }
                catch (ManagementException e) {
                    if (e.getResponse().getStatusCode() == 404) {
                        LOGGER.warning("Network interface not found '{}'", nicID);
                    }
                    throw LOGGER.logExceptionAsError(e);
                }
            }
            if (nic == null) continue;
            nics.put(nic.id(), nic);
            NicIpConfiguration ipConfig = nic.ipConfigurations().get(ipConfigName);
            if (ipConfig == null) continue;
            ipConfigs.add(ipConfig);
        }
        return Collections.unmodifiableCollection(ipConfigs);
    }

    @Override
    public Set<String> listAvailablePrivateIPAddresses() {
        Set<String> result = Collections.emptySet();
        if (!CoreUtils.isNullOrEmpty(this.addressPrefixes())) {
            for (String cidr : this.addressPrefixes()) {
                Set<String> availableIps = this.listAvailablePrivateIPAddresses(cidr);
                if (CoreUtils.isNullOrEmpty(availableIps)) continue;
                result = availableIps;
                break;
            }
        } else {
            result = this.listAvailablePrivateIPAddresses(this.addressPrefix());
        }
        return result;
    }

    @Override
    public SubnetImpl withDelegation(String serviceName) {
        if (((SubnetInner)this.innerModel()).delegations() == null) {
            ((SubnetInner)this.innerModel()).withDelegations(new ArrayList<Delegation>());
        }
        ((SubnetInner)this.innerModel()).delegations().add(new Delegation().withName(serviceName).withServiceName(serviceName));
        return this;
    }

    @Override
    public SubnetImpl withoutDelegation(String serviceName) {
        if (((SubnetInner)this.innerModel()).delegations() != null) {
            int i = 0;
            while (i < ((SubnetInner)this.innerModel()).delegations().size()) {
                if (serviceName.equalsIgnoreCase(((SubnetInner)this.innerModel()).delegations().get(i).serviceName())) {
                    ((SubnetInner)this.innerModel()).delegations().remove(i);
                    continue;
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public SubnetImpl enableNetworkPoliciesOnPrivateEndpoint() {
        ((SubnetInner)this.innerModel()).withPrivateEndpointNetworkPolicies(VirtualNetworkPrivateEndpointNetworkPolicies.ENABLED);
        return this;
    }

    @Override
    public SubnetImpl disableNetworkPoliciesOnPrivateEndpoint() {
        ((SubnetInner)this.innerModel()).withPrivateEndpointNetworkPolicies(VirtualNetworkPrivateEndpointNetworkPolicies.DISABLED);
        return this;
    }

    @Override
    public SubnetImpl enableNetworkPoliciesOnPrivateLinkService() {
        ((SubnetInner)this.innerModel()).withPrivateLinkServiceNetworkPolicies(VirtualNetworkPrivateLinkServiceNetworkPolicies.ENABLED);
        return this;
    }

    @Override
    public SubnetImpl disableNetworkPoliciesOnPrivateLinkService() {
        ((SubnetInner)this.innerModel()).withPrivateLinkServiceNetworkPolicies(VirtualNetworkPrivateLinkServiceNetworkPolicies.DISABLED);
        return this;
    }

    @Override
    public SubnetImpl withExistingNatGateway(String resourceId) {
        if (resourceId == null) {
            ((SubnetInner)this.innerModel()).withNatGateway(null);
        } else {
            ((SubnetInner)this.innerModel()).withNatGateway(new SubResource().withId(resourceId));
        }
        return this;
    }

    private Set<String> listAvailablePrivateIPAddresses(String cidr) {
        TreeSet<String> ipAddresses = new TreeSet<String>();
        if (cidr == null) {
            return ipAddresses;
        }
        String takenIPAddress = cidr.split("/")[0];
        IpAddressAvailabilityResultInner result = ((NetworkManagementClient)((NetworkManager)((NetworkImpl)this.parent()).manager()).serviceClient()).getVirtualNetworks().checkIpAddressAvailability(((NetworkImpl)this.parent()).resourceGroupName(), ((NetworkImpl)this.parent()).name(), takenIPAddress);
        if (result == null || result.availableIpAddresses() == null) {
            return ipAddresses;
        }
        ipAddresses.addAll(result.availableIpAddresses());
        return ipAddresses;
    }
}

