/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.WebApplicationFirewallPolicyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.KnownWebApplicationGatewayManagedRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedRuleGroupOverride;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedRulesDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.OwaspCrsExclusionEntry;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PolicySettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallEnabledState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class WebApplicationFirewallPolicyImpl
extends GroupableResourceImpl<WebApplicationFirewallPolicy, WebApplicationFirewallPolicyInner, WebApplicationFirewallPolicyImpl, NetworkManager>
implements WebApplicationFirewallPolicy,
WebApplicationFirewallPolicy.Definition,
WebApplicationFirewallPolicy.Update,
WebApplicationFirewallPolicy.UpdateStages.WithRequestBodyOrUpdate {
    private static final String BOT_DETECTION_RULE_SET_TYPE = "Microsoft_BotManagerRuleSet";
    private static final String BOT_DETECTION_RULE_SET_VERSION_DEFAULT = "0.1";

    protected WebApplicationFirewallPolicyImpl(String name, WebApplicationFirewallPolicyInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    public WebApplicationFirewallMode mode() {
        if (((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings() == null) {
            return null;
        }
        return ((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings().mode();
    }

    @Override
    public boolean isRequestBodyInspectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings().requestBodyCheck());
    }

    @Override
    public Integer requestBodySizeLimitInKb() {
        return ((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings().requestBodyInspectLimitInKB();
    }

    @Override
    public Integer fileUploadSizeLimitInMb() {
        return ((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings().fileUploadLimitInMb();
    }

    @Override
    public PolicySettings getPolicySettings() {
        return ((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings();
    }

    @Override
    public ManagedRulesDefinition getManagedRules() {
        return ((WebApplicationFirewallPolicyInner)this.innerModel()).managedRules();
    }

    @Override
    public boolean isEnabled() {
        return WebApplicationFirewallEnabledState.ENABLED.equals(((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings().state());
    }

    @Override
    public List<String> getAssociatedApplicationGatewayIds() {
        if (CoreUtils.isNullOrEmpty(((WebApplicationFirewallPolicyInner)this.innerModel()).applicationGateways())) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((WebApplicationFirewallPolicyInner)this.innerModel()).applicationGateways().stream().map(ApplicationGatewayInner::id).collect(Collectors.toList()));
    }

    @Override
    public List<ApplicationGateway> getAssociatedApplicationGateways() {
        List<ApplicationGateway> associatedGateways = this.getAssociatedApplicationGatewaysAsync().collectList().block();
        if (associatedGateways == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(associatedGateways);
    }

    @Override
    public Flux<ApplicationGateway> getAssociatedApplicationGatewaysAsync() {
        return Flux.fromIterable(this.getAssociatedApplicationGatewayIds()).flatMap(applicationGatewayId -> ((NetworkManager)this.manager()).applicationGateways().getByIdAsync((String)applicationGatewayId));
    }

    @Override
    public WebApplicationFirewallPolicyImpl withDetectionMode() {
        return this.withMode(WebApplicationFirewallMode.DETECTION);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withPreventionMode() {
        return this.withMode(WebApplicationFirewallMode.PREVENTION);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withMode(WebApplicationFirewallMode mode) {
        this.ensurePolicySettings().withMode(mode);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl enablePolicy() {
        this.ensurePolicySettings().withState(WebApplicationFirewallEnabledState.ENABLED);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl disablePolicy() {
        this.ensurePolicySettings().withState(WebApplicationFirewallEnabledState.DISABLED);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withBotProtection() {
        return this.withBotProtection(BOT_DETECTION_RULE_SET_VERSION_DEFAULT);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withoutBotProtection() {
        this.ensureManagedRules().managedRuleSets().removeIf(ruleSet -> BOT_DETECTION_RULE_SET_TYPE.equals(ruleSet.ruleSetType()));
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withBotProtection(String version) {
        String versionOrDefault = CoreUtils.isNullOrEmpty(version) ? BOT_DETECTION_RULE_SET_VERSION_DEFAULT : version;
        Optional<ManagedRuleSet> ruleSetOptional = this.ensureManagedRules().managedRuleSets().stream().filter(ruleSet -> BOT_DETECTION_RULE_SET_TYPE.equals(ruleSet.ruleSetType())).findFirst();
        if (ruleSetOptional.isPresent()) {
            ManagedRuleSet ruleSet2 = ruleSetOptional.get();
            if (version != null) {
                ruleSet2.withRuleSetVersion(version);
            }
        } else {
            this.ensureManagedRules().managedRuleSets().add(new ManagedRuleSet().withRuleSetType(BOT_DETECTION_RULE_SET_TYPE).withRuleSetVersion(versionOrDefault));
        }
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl enableRequestBodyInspection() {
        this.ensurePolicySettings().withRequestBodyCheck(true);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl disableRequestBodyInspection() {
        this.ensurePolicySettings().withRequestBodyCheck(false);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withRequestBodySizeLimitInKb(int limitInKb) {
        this.ensurePolicySettings().withRequestBodyInspectLimitInKB(limitInKb).withMaxRequestBodySizeInKb(limitInKb);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withFileUploadSizeLimitInMb(int limitInMb) {
        this.ensurePolicySettings().withFileUploadLimitInMb(limitInMb);
        return this;
    }

    @Override
    public Mono<WebApplicationFirewallPolicy> createResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getWebApplicationFirewallPolicies().createOrUpdateAsync(this.resourceGroupName(), this.name(), (WebApplicationFirewallPolicyInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    public WebApplicationFirewallPolicyImpl withManagedRuleSet(KnownWebApplicationGatewayManagedRuleSet managedRuleSet, ManagedRuleGroupOverride ... managedRuleGroupOverrides) {
        Objects.requireNonNull(managedRuleSet);
        return this.withManagedRuleSet(managedRuleSet.type(), managedRuleSet.version(), managedRuleGroupOverrides);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withManagedRuleSet(String type, String version, ManagedRuleGroupOverride ... managedRuleGroupOverrides) {
        ManagedRuleSet managedRuleSet = new ManagedRuleSet().withRuleSetType(type).withRuleSetVersion(version);
        if (managedRuleGroupOverrides != null) {
            managedRuleSet.withRuleGroupOverrides(Arrays.stream(managedRuleGroupOverrides).collect(Collectors.toList()));
        }
        return this.withManagedRuleSet(managedRuleSet);
    }

    @Override
    public WebApplicationFirewallPolicyImpl withManagedRuleSet(ManagedRuleSet managedRuleSet) {
        Objects.requireNonNull(managedRuleSet);
        ManagedRulesDefinition managedRules = this.ensureManagedRules();
        this.withoutManagedRuleSet(managedRuleSet.ruleSetType(), managedRuleSet.ruleSetVersion());
        managedRules.managedRuleSets().add(managedRuleSet);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withoutManagedRuleSet(KnownWebApplicationGatewayManagedRuleSet managedRuleSet) {
        Objects.requireNonNull(managedRuleSet);
        return this.withoutManagedRuleSet(managedRuleSet.type(), managedRuleSet.version());
    }

    @Override
    public WebApplicationFirewallPolicyImpl withoutManagedRuleSet(String type, String version) {
        if (((WebApplicationFirewallPolicyInner)this.innerModel()).managedRules() != null && ((WebApplicationFirewallPolicyInner)this.innerModel()).managedRules().managedRuleSets() != null) {
            ((WebApplicationFirewallPolicyInner)this.innerModel()).managedRules().managedRuleSets().removeIf(ruleSet -> Objects.equals(type, ruleSet.ruleSetType()) && Objects.equals(version, ruleSet.ruleSetVersion()));
        }
        return this;
    }

    @Override
    protected Mono<WebApplicationFirewallPolicyInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getWebApplicationFirewallPolicies().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private PolicySettings ensurePolicySettings() {
        if (((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings() == null) {
            PolicySettings policySettings = new PolicySettings();
            ((WebApplicationFirewallPolicyInner)this.innerModel()).withPolicySettings(policySettings);
        }
        return ((WebApplicationFirewallPolicyInner)this.innerModel()).policySettings();
    }

    private ManagedRulesDefinition ensureManagedRules() {
        ManagedRulesDefinition managedRulesDefinition = ((WebApplicationFirewallPolicyInner)this.innerModel()).managedRules();
        if (managedRulesDefinition == null) {
            managedRulesDefinition = new ManagedRulesDefinition();
            ((WebApplicationFirewallPolicyInner)this.innerModel()).withManagedRules(managedRulesDefinition);
            if (managedRulesDefinition.managedRuleSets() == null) {
                managedRulesDefinition.withManagedRuleSets(new ArrayList<ManagedRuleSet>());
            }
            if (managedRulesDefinition.exclusions() == null) {
                managedRulesDefinition.withExclusions(new ArrayList<OwaspCrsExclusionEntry>());
            }
        }
        return managedRulesDefinition;
    }
}

