/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpamPoolPrefixAllocation;
import java.io.IOException;
import java.util.List;

public final class AddressSpace
implements JsonSerializable<AddressSpace> {
    private List<String> addressPrefixes;
    private List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations;

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public AddressSpace withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations() {
        return this.ipamPoolPrefixAllocations;
    }

    public AddressSpace withIpamPoolPrefixAllocations(List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations) {
        this.ipamPoolPrefixAllocations = ipamPoolPrefixAllocations;
        return this;
    }

    public void validate() {
        if (this.ipamPoolPrefixAllocations() != null) {
            this.ipamPoolPrefixAllocations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("ipamPoolPrefixAllocations", this.ipamPoolPrefixAllocations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AddressSpace fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AddressSpace deserializedAddressSpace = new AddressSpace();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedAddressSpace.addressPrefixes = addressPrefixes;
                    continue;
                }
                if ("ipamPoolPrefixAllocations".equals(fieldName)) {
                    List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations = reader.readArray(reader1 -> IpamPoolPrefixAllocation.fromJson(reader1));
                    deserializedAddressSpace.ipamPoolPrefixAllocations = ipamPoolPrefixAllocations;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAddressSpace;
        });
    }
}

