/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AzureFirewallApplicationRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class AzureFirewallApplicationRule
implements JsonSerializable<AzureFirewallApplicationRule> {
    private String name;
    private String description;
    private List<String> sourceAddresses;
    private List<AzureFirewallApplicationRuleProtocol> protocols;
    private List<String> targetFqdns;
    private List<String> fqdnTags;
    private List<String> sourceIpGroups;

    public String name() {
        return this.name;
    }

    public AzureFirewallApplicationRule withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AzureFirewallApplicationRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public AzureFirewallApplicationRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    public List<AzureFirewallApplicationRuleProtocol> protocols() {
        return this.protocols;
    }

    public AzureFirewallApplicationRule withProtocols(List<AzureFirewallApplicationRuleProtocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    public List<String> targetFqdns() {
        return this.targetFqdns;
    }

    public AzureFirewallApplicationRule withTargetFqdns(List<String> targetFqdns) {
        this.targetFqdns = targetFqdns;
        return this;
    }

    public List<String> fqdnTags() {
        return this.fqdnTags;
    }

    public AzureFirewallApplicationRule withFqdnTags(List<String> fqdnTags) {
        this.fqdnTags = fqdnTags;
        return this;
    }

    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    public AzureFirewallApplicationRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    public void validate() {
        if (this.protocols() != null) {
            this.protocols().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("sourceAddresses", this.sourceAddresses, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("targetFqdns", this.targetFqdns, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("fqdnTags", this.fqdnTags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("sourceIpGroups", this.sourceIpGroups, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallApplicationRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallApplicationRule deserializedAzureFirewallApplicationRule = new AzureFirewallApplicationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRule.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRule.description = reader.getString();
                    continue;
                }
                if ("sourceAddresses".equals(fieldName)) {
                    List<String> sourceAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.sourceAddresses = sourceAddresses;
                    continue;
                }
                if ("protocols".equals(fieldName)) {
                    List<AzureFirewallApplicationRuleProtocol> protocols = reader.readArray(reader1 -> AzureFirewallApplicationRuleProtocol.fromJson(reader1));
                    deserializedAzureFirewallApplicationRule.protocols = protocols;
                    continue;
                }
                if ("targetFqdns".equals(fieldName)) {
                    List<String> targetFqdns = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.targetFqdns = targetFqdns;
                    continue;
                }
                if ("fqdnTags".equals(fieldName)) {
                    List<String> fqdnTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.fqdnTags = fqdnTags;
                    continue;
                }
                if ("sourceIpGroups".equals(fieldName)) {
                    List<String> sourceIpGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.sourceIpGroups = sourceIpGroups;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallApplicationRule;
        });
    }
}

