/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExceptionEntry;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.OwaspCrsExclusionEntry;
import java.io.IOException;
import java.util.List;

public final class ManagedRulesDefinition
implements JsonSerializable<ManagedRulesDefinition> {
    private List<ExceptionEntry> exceptions;
    private List<OwaspCrsExclusionEntry> exclusions;
    private List<ManagedRuleSet> managedRuleSets;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRulesDefinition.class);

    public List<ExceptionEntry> exceptions() {
        return this.exceptions;
    }

    public ManagedRulesDefinition withExceptions(List<ExceptionEntry> exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    public List<OwaspCrsExclusionEntry> exclusions() {
        return this.exclusions;
    }

    public ManagedRulesDefinition withExclusions(List<OwaspCrsExclusionEntry> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public List<ManagedRuleSet> managedRuleSets() {
        return this.managedRuleSets;
    }

    public ManagedRulesDefinition withManagedRuleSets(List<ManagedRuleSet> managedRuleSets) {
        this.managedRuleSets = managedRuleSets;
        return this;
    }

    public void validate() {
        if (this.exceptions() != null) {
            this.exceptions().forEach(e -> e.validate());
        }
        if (this.exclusions() != null) {
            this.exclusions().forEach(e -> e.validate());
        }
        if (this.managedRuleSets() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property managedRuleSets in model ManagedRulesDefinition"));
        }
        this.managedRuleSets().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("managedRuleSets", this.managedRuleSets, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("exceptions", this.exceptions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("exclusions", this.exclusions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedRulesDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRulesDefinition deserializedManagedRulesDefinition = new ManagedRulesDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedRuleSets".equals(fieldName)) {
                    List<ManagedRuleSet> managedRuleSets = reader.readArray(reader1 -> ManagedRuleSet.fromJson(reader1));
                    deserializedManagedRulesDefinition.managedRuleSets = managedRuleSets;
                    continue;
                }
                if ("exceptions".equals(fieldName)) {
                    List<ExceptionEntry> exceptions = reader.readArray(reader1 -> ExceptionEntry.fromJson(reader1));
                    deserializedManagedRulesDefinition.exceptions = exceptions;
                    continue;
                }
                if ("exclusions".equals(fieldName)) {
                    List<OwaspCrsExclusionEntry> exclusions = reader.readArray(reader1 -> OwaspCrsExclusionEntry.fromJson(reader1));
                    deserializedManagedRulesDefinition.exclusions = exclusions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedRulesDefinition;
        });
    }
}

