/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class RecordSet
implements JsonSerializable<RecordSet> {
    private String recordType;
    private String recordSetName;
    private String fqdn;
    private ProvisioningState provisioningState;
    private Integer ttl;
    private List<String> ipAddresses;

    public String recordType() {
        return this.recordType;
    }

    public RecordSet withRecordType(String recordType) {
        this.recordType = recordType;
        return this;
    }

    public String recordSetName() {
        return this.recordSetName;
    }

    public RecordSet withRecordSetName(String recordSetName) {
        this.recordSetName = recordSetName;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public RecordSet withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer ttl() {
        return this.ttl;
    }

    public RecordSet withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public RecordSet withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recordType", this.recordType);
        jsonWriter.writeStringField("recordSetName", this.recordSetName);
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeNumberField("ttl", this.ttl);
        jsonWriter.writeArrayField("ipAddresses", this.ipAddresses, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static RecordSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecordSet deserializedRecordSet = new RecordSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recordType".equals(fieldName)) {
                    deserializedRecordSet.recordType = reader.getString();
                    continue;
                }
                if ("recordSetName".equals(fieldName)) {
                    deserializedRecordSet.recordSetName = reader.getString();
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedRecordSet.fqdn = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRecordSet.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("ttl".equals(fieldName)) {
                    deserializedRecordSet.ttl = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ipAddresses".equals(fieldName)) {
                    List<String> ipAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecordSet.ipAddresses = ipAddresses;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecordSet;
        });
    }
}

