/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.fluent.PrivateDnsManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.fluent.models.PrivateZoneInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.ARecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.ARecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.AaaaRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.AaaaRecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.CnameRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.CnameRecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.MxRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.MxRecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.PrivateDnsRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.PrivateDnsRecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.PtrRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.PtrRecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.SoaRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.SrvRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.SrvRecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.TxtRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.TxtRecordSetsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.VirtualNetworkLinkImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.implementation.VirtualNetworkLinksImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.ARecordSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.AaaaRecordSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.CnameRecordSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.MxRecordSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.PrivateDnsRecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.PrivateDnsZone;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.PtrRecordSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.RecordType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.SoaRecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.SrvRecordSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.TxtRecordSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.VirtualNetworkLinks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class PrivateDnsZoneImpl
extends GroupableResourceImpl<PrivateDnsZone, PrivateZoneInner, PrivateDnsZoneImpl, PrivateDnsZoneManager>
implements PrivateDnsZone,
PrivateDnsZone.Definition,
PrivateDnsZone.Update {
    private AaaaRecordSets aaaaRecordSets;
    private ARecordSets aRecordSets;
    private CnameRecordSets cnameRecordSets;
    private MxRecordSets mxRecordSets;
    private PtrRecordSets ptrRecordSets;
    private SrvRecordSets srvRecordSets;
    private TxtRecordSets txtRecordSets;
    private PrivateDnsRecordSetsImpl recordSets;
    private VirtualNetworkLinksImpl virtualNetworkLinks;
    private final ETagState etagState = new ETagState();
    private Map<String, String> resourceTagsSnapshotOnUpdate = null;

    PrivateDnsZoneImpl(String name, PrivateZoneInner innerModel, PrivateDnsZoneManager manager) {
        super(name, innerModel, manager);
        this.recordSets = new PrivateDnsRecordSetsImpl(this);
        this.virtualNetworkLinks = new VirtualNetworkLinksImpl(this);
        this.initRecordSets();
    }

    private void initRecordSets() {
        this.aaaaRecordSets = new AaaaRecordSetsImpl(this);
        this.aRecordSets = new ARecordSetsImpl(this);
        this.cnameRecordSets = new CnameRecordSetsImpl(this);
        this.mxRecordSets = new MxRecordSetsImpl(this);
        this.ptrRecordSets = new PtrRecordSetsImpl(this);
        this.srvRecordSets = new SrvRecordSetsImpl(this);
        this.txtRecordSets = new TxtRecordSetsImpl(this);
    }

    @Override
    public String etag() {
        return ((PrivateZoneInner)this.innerModel()).etag();
    }

    @Override
    public long maxNumberOfRecordSets() {
        return ResourceManagerUtils.toPrimitiveLong(((PrivateZoneInner)this.innerModel()).maxNumberOfRecordSets());
    }

    @Override
    public long numberOfRecordSets() {
        return ResourceManagerUtils.toPrimitiveLong(((PrivateZoneInner)this.innerModel()).numberOfRecordSets());
    }

    @Override
    public long maxNumberOfVirtualNetworkLinks() {
        return ResourceManagerUtils.toPrimitiveLong(((PrivateZoneInner)this.innerModel()).maxNumberOfVirtualNetworkLinks());
    }

    @Override
    public long numberOfVirtualNetworkLinks() {
        return ResourceManagerUtils.toPrimitiveLong(((PrivateZoneInner)this.innerModel()).numberOfVirtualNetworkLinks());
    }

    @Override
    public long maxNumberOfVirtualNetworkLinksWithRegistration() {
        return ResourceManagerUtils.toPrimitiveLong(((PrivateZoneInner)this.innerModel()).maxNumberOfVirtualNetworkLinksWithRegistration());
    }

    @Override
    public long numberOfVirtualNetworkLinksWithRegistration() {
        return ResourceManagerUtils.toPrimitiveLong(((PrivateZoneInner)this.innerModel()).numberOfVirtualNetworkLinksWithRegistration());
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PrivateZoneInner)this.innerModel()).provisioningState();
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets() {
        return this.listRecordSetsIntern(null, null);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync() {
        return this.listRecordSetsInternAsync(null, null);
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets(String recordSetNameSuffix) {
        return this.listRecordSetsIntern(recordSetNameSuffix, null);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync(String recordSetNameSuffix) {
        return this.listRecordSetsInternAsync(recordSetNameSuffix, null);
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets(int pageSize) {
        return this.listRecordSetsIntern(null, pageSize);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync(int pageSize) {
        return this.listRecordSetsInternAsync(null, pageSize);
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets(String recordSetNameSuffix, int pageSize) {
        return this.listRecordSetsIntern(recordSetNameSuffix, pageSize);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync(String recordSetNameSuffix, int pageSize) {
        return this.listRecordSetsInternAsync(recordSetNameSuffix, pageSize);
    }

    @Override
    public AaaaRecordSets aaaaRecordSets() {
        return this.aaaaRecordSets;
    }

    @Override
    public ARecordSets aRecordSets() {
        return this.aRecordSets;
    }

    @Override
    public CnameRecordSets cnameRecordSets() {
        return this.cnameRecordSets;
    }

    @Override
    public MxRecordSets mxRecordSets() {
        return this.mxRecordSets;
    }

    @Override
    public PtrRecordSets ptrRecordSets() {
        return this.ptrRecordSets;
    }

    @Override
    public SoaRecordSet getSoaRecordSet() {
        RecordSetInner inner = ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getRecordSets().get(this.resourceGroupName(), this.name(), RecordType.SOA, "@");
        return inner == null ? null : new SoaRecordSetImpl(inner.name(), this, inner);
    }

    @Override
    public SrvRecordSets srvRecordSets() {
        return this.srvRecordSets;
    }

    @Override
    public TxtRecordSets txtRecordSets() {
        return this.txtRecordSets;
    }

    @Override
    public VirtualNetworkLinks virtualNetworkLinks() {
        return this.virtualNetworkLinks;
    }

    public PrivateDnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.recordSets.defineAaaaRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineARecordSet(String name) {
        return this.recordSets.defineARecordSet(name);
    }

    @Override
    public PrivateDnsZoneImpl withCnameRecordSet(String name, String alias) {
        this.recordSets.withCnameRecordSet(name, alias);
        return this;
    }

    public PrivateDnsRecordSetImpl defineCnameRecordSet(String name) {
        return this.recordSets.defineCnameRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineMxRecordSet(String name) {
        return this.recordSets.defineMxRecordSet(name);
    }

    public PrivateDnsRecordSetImpl definePtrRecordSet(String name) {
        return this.recordSets.definePtrRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineSoaRecordSet() {
        return this.recordSets.defineSoaRecordSet();
    }

    public PrivateDnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.recordSets.defineSrvRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.recordSets.defineTxtRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateAaaaRecordSet(String name) {
        return this.recordSets.updateAaaaRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateARecordSet(String name) {
        return this.recordSets.updateARecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateCnameRecordSet(String name) {
        return this.recordSets.updateCnameRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateMxRecordSet(String name) {
        return this.recordSets.updateMxRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updatePtrRecordSet(String name) {
        return this.recordSets.updatePtrRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateSoaRecord() {
        return this.recordSets.updateSoaRecordSet();
    }

    @Override
    public PrivateDnsRecordSetImpl updateSrvRecordSet(String name) {
        return this.recordSets.updateSrvRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateTxtRecordSet(String name) {
        return this.recordSets.updateTxtRecordSet(name);
    }

    @Override
    public PrivateDnsZoneImpl withoutAaaaRecordSet(String name) {
        return this.withoutAaaaRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutAaaaRecordSet(String name, String etagValue) {
        this.recordSets.withoutAaaaRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutARecordSet(String name) {
        return this.withoutARecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutARecordSet(String name, String etagValue) {
        this.recordSets.withoutARecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutCNameRecordSet(String name) {
        return this.withoutCNameRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutCNameRecordSet(String name, String etagValue) {
        this.recordSets.withoutCnameRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutMXRecordSet(String name) {
        return this.withoutMXRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutMXRecordSet(String name, String etagValue) {
        this.recordSets.withoutMxRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutPtrRecordSet(String name) {
        return this.withoutPtrRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutPtrRecordSet(String name, String etagValue) {
        this.recordSets.withoutPtrRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutSrvRecordSet(String name) {
        return this.withoutSrvRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutSrvRecordSet(String name, String etagValue) {
        this.recordSets.withoutSrvRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutTxtRecordSet(String name) {
        return this.withoutTxtRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutTxtRecordSet(String name, String etagValue) {
        this.recordSets.withoutTxtRecordSet(name, etagValue);
        return this;
    }

    public VirtualNetworkLinkImpl defineVirtualNetworkLink(String name) {
        return this.virtualNetworkLinks.defineVirtualNetworkLink(name);
    }

    @Override
    public VirtualNetworkLinkImpl updateVirtualNetworkLink(String name) {
        return this.virtualNetworkLinks.updateVirtualNetworkLink(name);
    }

    @Override
    public PrivateDnsZoneImpl withoutVirtualNetworkLink(String name) {
        return this.withoutVirtualNetworkLink(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutVirtualNetworkLink(String name, String etagValue) {
        this.virtualNetworkLinks.withoutVirtualNetworkLink(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withETagCheck() {
        this.etagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public PrivateDnsZone.Update withETagCheck(String etagValue) {
        this.etagState.withExplicitETagCheckOnUpdate(etagValue);
        return this;
    }

    @Override
    public Mono<PrivateDnsZone> createResourceAsync() {
        Mono<Object> mono = this.isInCreateMode() ? ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getPrivateZones().createOrUpdateAsync(this.resourceGroupName(), this.name(), (PrivateZoneInner)this.innerModel(), this.etagState.ifMatchValueOnUpdate(((PrivateZoneInner)this.innerModel()).etag()), this.etagState.ifNonMatchValueOnCreate()).map(this.innerToFluentMap(this)) : (!Objects.equals(this.resourceTagsSnapshotOnUpdate, ((PrivateZoneInner)this.innerModel()).tags()) ? ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getPrivateZones().updateAsync(this.resourceGroupName(), this.name(), (PrivateZoneInner)this.innerModel(), this.etagState.ifMatchValueOnUpdate(((PrivateZoneInner)this.innerModel()).etag())).map(this.innerToFluentMap(this)) : Mono.just(this));
        return mono.map(privateDnsZone -> {
            this.etagState.clear();
            return privateDnsZone;
        });
    }

    @Override
    public PrivateDnsZoneImpl update() {
        this.resourceTagsSnapshotOnUpdate = this.innerModel() != null && ((PrivateZoneInner)this.innerModel()).tags() != null ? new HashMap<String, String>(((PrivateZoneInner)this.innerModel()).tags()) : null;
        return (PrivateDnsZoneImpl)super.update();
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        return Mono.just(true).map(ignored -> {
            this.recordSets.clear();
            this.virtualNetworkLinks.clear();
            return ignored;
        }).then();
    }

    @Override
    public Mono<PrivateDnsZone> refreshAsync() {
        return super.refreshAsync().map(privateDnsZone -> {
            PrivateDnsZoneImpl impl = (PrivateDnsZoneImpl)privateDnsZone;
            impl.initRecordSets();
            return impl;
        });
    }

    @Override
    protected Mono<PrivateZoneInner> getInnerAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getPrivateZones().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private PagedIterable<PrivateDnsRecordSet> listRecordSetsIntern(String recordSetSuffix, Integer pageSize) {
        return new PagedIterable<PrivateDnsRecordSet>(this.listRecordSetsInternAsync(recordSetSuffix, pageSize));
    }

    private PagedFlux<PrivateDnsRecordSet> listRecordSetsInternAsync(String recordSetSuffix, Integer pageSize) {
        PrivateDnsZoneImpl self = this;
        return PagedConverter.mapPage(((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getRecordSets().listAsync(this.resourceGroupName(), this.name(), pageSize, recordSetSuffix), recordSetInner -> {
            PrivateDnsRecordSetImpl recordSet = new PrivateDnsRecordSetImpl(recordSetInner.name(), recordSetInner.type(), self, (RecordSetInner)recordSetInner);
            switch (recordSet.recordType()) {
                case AAAA: {
                    return new AaaaRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
                case A: {
                    return new ARecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
                case CNAME: {
                    return new CnameRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
                case MX: {
                    return new MxRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
                case PTR: {
                    return new PtrRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
                case SOA: {
                    return new SoaRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
                case SRV: {
                    return new SrvRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
                case TXT: {
                    return new TxtRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)recordSetInner);
                }
            }
            return recordSet;
        });
    }
}

