/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.AccessPoliciesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisCacheAccessPolicyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.RedisManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisCacheAccessPolicyList;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class AccessPoliciesClientImpl
implements AccessPoliciesClient {
    private final AccessPoliciesService service;
    private final RedisManagementClientImpl client;

    AccessPoliciesClientImpl(RedisManagementClientImpl client) {
        this.service = RestProxy.create(AccessPoliciesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createUpdate(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createUpdate(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RedisCacheAccessPolicyInner>, RedisCacheAccessPolicyInner> beginCreateUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateWithResponseAsync(resourceGroupName, cacheName, accessPolicyName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)RedisCacheAccessPolicyInner.class), (Type)((Object)RedisCacheAccessPolicyInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RedisCacheAccessPolicyInner>, RedisCacheAccessPolicyInner> beginCreateUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateWithResponseAsync(resourceGroupName, cacheName, accessPolicyName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)RedisCacheAccessPolicyInner.class), (Type)((Object)RedisCacheAccessPolicyInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RedisCacheAccessPolicyInner>, RedisCacheAccessPolicyInner> beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RedisCacheAccessPolicyInner>, RedisCacheAccessPolicyInner> beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters, Context context) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RedisCacheAccessPolicyInner> createUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RedisCacheAccessPolicyInner> createUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters, Context context) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedisCacheAccessPolicyInner createUpdate(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters) {
        return this.createUpdateAsync(resourceGroupName, cacheName, accessPolicyName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedisCacheAccessPolicyInner createUpdate(String resourceGroupName, String cacheName, String accessPolicyName, RedisCacheAccessPolicyInner parameters, Context context) {
        return this.createUpdateAsync(resourceGroupName, cacheName, accessPolicyName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName, String accessPolicyName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cacheName, accessPolicyName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName, String accessPolicyName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cacheName, accessPolicyName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName, String accessPolicyName) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName, String accessPolicyName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String accessPolicyName) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String accessPolicyName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String accessPolicyName) {
        this.deleteAsync(resourceGroupName, cacheName, accessPolicyName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String accessPolicyName, Context context) {
        this.deleteAsync(resourceGroupName, cacheName, accessPolicyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RedisCacheAccessPolicyInner>> getWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RedisCacheAccessPolicyInner>> getWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RedisCacheAccessPolicyInner> getAsync(String resourceGroupName, String cacheName, String accessPolicyName) {
        return this.getWithResponseAsync(resourceGroupName, cacheName, accessPolicyName).flatMap(res -> Mono.justOrEmpty((RedisCacheAccessPolicyInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RedisCacheAccessPolicyInner> getWithResponse(String resourceGroupName, String cacheName, String accessPolicyName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, cacheName, accessPolicyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedisCacheAccessPolicyInner get(String resourceGroupName, String cacheName, String accessPolicyName) {
        return this.getWithResponse(resourceGroupName, cacheName, accessPolicyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyInner>> listSinglePageAsync(String resourceGroupName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, cacheName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RedisCacheAccessPolicyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyList)res.getValue()).value(), ((RedisCacheAccessPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyInner>> listSinglePageAsync(String resourceGroupName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, cacheName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, RedisCacheAccessPolicyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyList)res.getValue()).value(), ((RedisCacheAccessPolicyList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RedisCacheAccessPolicyInner> listAsync(String resourceGroupName, String cacheName) {
        return new PagedFlux<RedisCacheAccessPolicyInner>(() -> this.listSinglePageAsync(resourceGroupName, cacheName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RedisCacheAccessPolicyInner> listAsync(String resourceGroupName, String cacheName, Context context) {
        return new PagedFlux<RedisCacheAccessPolicyInner>(() -> this.listSinglePageAsync(resourceGroupName, cacheName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RedisCacheAccessPolicyInner> list(String resourceGroupName, String cacheName) {
        return new PagedIterable<RedisCacheAccessPolicyInner>(this.listAsync(resourceGroupName, cacheName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RedisCacheAccessPolicyInner> list(String resourceGroupName, String cacheName, Context context) {
        return new PagedIterable<RedisCacheAccessPolicyInner>(this.listAsync(resourceGroupName, cacheName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RedisCacheAccessPolicyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyList)res.getValue()).value(), ((RedisCacheAccessPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, RedisCacheAccessPolicyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyList)res.getValue()).value(), ((RedisCacheAccessPolicyList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RedisManagementClien")
    public static interface AccessPoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicies/{accessPolicyName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @PathParam(value="accessPolicyName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") RedisCacheAccessPolicyInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicies/{accessPolicyName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @PathParam(value="accessPolicyName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicies/{accessPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisCacheAccessPolicyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @PathParam(value="accessPolicyName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisCacheAccessPolicyList>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisCacheAccessPolicyList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

