/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.LockLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ManagementLockOwner;
import java.io.IOException;
import java.util.List;

public final class ManagementLockProperties
implements JsonSerializable<ManagementLockProperties> {
    private LockLevel level;
    private String notes;
    private List<ManagementLockOwner> owners;
    private static final ClientLogger LOGGER = new ClientLogger(ManagementLockProperties.class);

    public LockLevel level() {
        return this.level;
    }

    public ManagementLockProperties withLevel(LockLevel level) {
        this.level = level;
        return this;
    }

    public String notes() {
        return this.notes;
    }

    public ManagementLockProperties withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public List<ManagementLockOwner> owners() {
        return this.owners;
    }

    public ManagementLockProperties withOwners(List<ManagementLockOwner> owners) {
        this.owners = owners;
        return this;
    }

    public void validate() {
        if (this.level() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property level in model ManagementLockProperties"));
        }
        if (this.owners() != null) {
            this.owners().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("notes", this.notes);
        jsonWriter.writeArrayField("owners", this.owners, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagementLockProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementLockProperties deserializedManagementLockProperties = new ManagementLockProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("level".equals(fieldName)) {
                    deserializedManagementLockProperties.level = LockLevel.fromString(reader.getString());
                    continue;
                }
                if ("notes".equals(fieldName)) {
                    deserializedManagementLockProperties.notes = reader.getString();
                    continue;
                }
                if ("owners".equals(fieldName)) {
                    List<ManagementLockOwner> owners = reader.readArray(reader1 -> ManagementLockOwner.fromJson(reader1));
                    deserializedManagementLockProperties.owners = owners;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementLockProperties;
        });
    }
}

