/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.AddDatePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogDetailLevel;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLoggingPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPolicyProviders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RequestIdPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.policy.AuthenticationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.policy.ReturnRequestIdHeaderPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.policy.UserAgentPolicy;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class HttpPipelineProvider {
    private HttpPipelineProvider() {
    }

    public static HttpPipeline buildHttpPipeline(TokenCredential credential, AzureProfile profile) {
        return HttpPipelineProvider.buildHttpPipeline(credential, profile, null, new HttpLogOptions().setLogLevel(HttpLogDetailLevel.NONE), null, null, null, null);
    }

    public static HttpPipeline buildHttpPipeline(TokenCredential credential, AzureProfile profile, String[] scopes, HttpLogOptions httpLogOptions, Configuration configuration, RetryPolicy retryPolicy, List<HttpPipelinePolicy> additionalPolicies, HttpClient httpClient) {
        if (retryPolicy == null) {
            retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
        }
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(new UserAgentPolicy(httpLogOptions, configuration));
        policies.add(new AddHeadersFromContextPolicy());
        policies.add(new RequestIdPolicy());
        policies.add(new ReturnRequestIdHeaderPolicy(ReturnRequestIdHeaderPolicy.Option.COPY_CLIENT_REQUEST_ID));
        if (!CoreUtils.isNullOrEmpty(additionalPolicies)) {
            policies.addAll(additionalPolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
        }
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(retryPolicy);
        policies.add(new AddDatePolicy());
        if (credential != null) {
            policies.add(new AuthenticationPolicy(credential, profile.getEnvironment(), scopes));
        }
        policies.add(new ProviderRegistrationPolicy());
        if (!CoreUtils.isNullOrEmpty(additionalPolicies)) {
            policies.addAll(additionalPolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
        }
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }
}

