/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.ResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.DeploymentsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.SupportsGettingByResourceGroupImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.DeploymentImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Deployment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Deployments;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class DeploymentsImpl
extends SupportsGettingByResourceGroupImpl<Deployment>
implements Deployments,
HasManager<ResourceManager> {
    private final ResourceManager resourceManager;

    public DeploymentsImpl(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public PagedIterable<Deployment> list() {
        return new PagedIterable<Deployment>(this.listAsync());
    }

    @Override
    public PagedIterable<Deployment> listByResourceGroup(String groupName) {
        return PagedConverter.mapPage(((ResourceManagementClient)this.manager().serviceClient()).getDeployments().listByResourceGroup(groupName), inner -> this.createFluentModel((DeploymentExtendedInner)inner));
    }

    @Override
    public Deployment getByName(String name) {
        return this.getByNameAsync(name).block();
    }

    @Override
    public Mono<Deployment> getByNameAsync(String name) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().getAtTenantScopeAsync(name).map(inner -> new DeploymentImpl((DeploymentExtendedInner)inner, inner.name(), this.resourceManager));
    }

    @Override
    public Mono<Deployment> getByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(name)) {
            return Mono.error(new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().getByResourceGroupAsync(resourceGroupName, name).map(deploymentExtendedInner -> {
            if (deploymentExtendedInner != null) {
                return this.createFluentModel((DeploymentExtendedInner)deploymentExtendedInner);
            }
            return null;
        });
    }

    @Override
    public void deleteByResourceGroup(String groupName, String name) {
        this.deleteByResourceGroupAsync(groupName, name).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(name)) {
            return Mono.error(new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().deleteAsync(resourceGroupName, name);
    }

    @Override
    public DeploymentImpl define(String name) {
        return this.createFluentModel(name);
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().checkExistence(resourceGroupName, deploymentName);
    }

    protected DeploymentImpl createFluentModel(String name) {
        return new DeploymentImpl(new DeploymentExtendedInner(), name, this.resourceManager);
    }

    protected DeploymentImpl createFluentModel(DeploymentExtendedInner deploymentExtendedInner) {
        return new DeploymentImpl(deploymentExtendedInner, deploymentExtendedInner.name(), this.resourceManager);
    }

    @Override
    public Deployment getById(String id) {
        return (Deployment)this.getByResourceGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByResourceGroupAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public ResourceManager manager() {
        return this.resourceManager;
    }

    @Override
    public PagedFlux<Deployment> listAsync() {
        return PagedConverter.mergePagedFlux(this.manager().resourceGroups().listAsync(), resourceGroup -> this.listByResourceGroupAsync(resourceGroup.name()));
    }

    @Override
    public PagedFlux<Deployment> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<Deployment>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        DeploymentsClient client = ((ResourceManagementClient)this.manager().serviceClient()).getDeployments();
        return PagedConverter.mapPage(client.listByResourceGroupAsync(resourceGroupName), deploymentExtendedInner -> this.createFluentModel((DeploymentExtendedInner)deploymentExtendedInner));
    }
}

