/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.DenySettingsMode;
import java.io.IOException;
import java.util.List;

public final class DenySettings
implements JsonSerializable<DenySettings> {
    private DenySettingsMode mode;
    private List<String> excludedPrincipals;
    private List<String> excludedActions;
    private Boolean applyToChildScopes;
    private static final ClientLogger LOGGER = new ClientLogger(DenySettings.class);

    public DenySettingsMode mode() {
        return this.mode;
    }

    public DenySettings withMode(DenySettingsMode mode) {
        this.mode = mode;
        return this;
    }

    public List<String> excludedPrincipals() {
        return this.excludedPrincipals;
    }

    public DenySettings withExcludedPrincipals(List<String> excludedPrincipals) {
        this.excludedPrincipals = excludedPrincipals;
        return this;
    }

    public List<String> excludedActions() {
        return this.excludedActions;
    }

    public DenySettings withExcludedActions(List<String> excludedActions) {
        this.excludedActions = excludedActions;
        return this;
    }

    public Boolean applyToChildScopes() {
        return this.applyToChildScopes;
    }

    public DenySettings withApplyToChildScopes(Boolean applyToChildScopes) {
        this.applyToChildScopes = applyToChildScopes;
        return this;
    }

    public void validate() {
        if (this.mode() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property mode in model DenySettings"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeArrayField("excludedPrincipals", this.excludedPrincipals, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("excludedActions", this.excludedActions, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("applyToChildScopes", this.applyToChildScopes);
        return jsonWriter.writeEndObject();
    }

    public static DenySettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DenySettings deserializedDenySettings = new DenySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedDenySettings.mode = DenySettingsMode.fromString(reader.getString());
                    continue;
                }
                if ("excludedPrincipals".equals(fieldName)) {
                    List<String> excludedPrincipals = reader.readArray(reader1 -> reader1.getString());
                    deserializedDenySettings.excludedPrincipals = excludedPrincipals;
                    continue;
                }
                if ("excludedActions".equals(fieldName)) {
                    List<String> excludedActions = reader.readArray(reader1 -> reader1.getString());
                    deserializedDenySettings.excludedActions = excludedActions;
                    continue;
                }
                if ("applyToChildScopes".equals(fieldName)) {
                    deserializedDenySettings.applyToChildScopes = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDenySettings;
        });
    }
}

