/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Alias;
import java.io.IOException;
import java.util.List;

public final class ResourceTypeAliases
implements JsonSerializable<ResourceTypeAliases> {
    private String resourceType;
    private List<Alias> aliases;

    public String resourceType() {
        return this.resourceType;
    }

    public ResourceTypeAliases withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public List<Alias> aliases() {
        return this.aliases;
    }

    public ResourceTypeAliases withAliases(List<Alias> aliases) {
        this.aliases = aliases;
        return this;
    }

    public void validate() {
        if (this.aliases() != null) {
            this.aliases().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeArrayField("aliases", this.aliases, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeAliases fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceTypeAliases deserializedResourceTypeAliases = new ResourceTypeAliases();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceTypeAliases.resourceType = reader.getString();
                    continue;
                }
                if ("aliases".equals(fieldName)) {
                    List<Alias> aliases = reader.readArray(reader1 -> Alias.fromJson(reader1));
                    deserializedResourceTypeAliases.aliases = aliases;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeAliases;
        });
    }
}

